<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Site Transfer - <?php echo e($siteTransfer->transfer_number ?? 'ST-' . str_pad($siteTransfer->id, 5, '0', STR_PAD_LEFT)); ?></title>
    <style>
        @media print {
            body { margin: 0; }
            .no-print { display: none; }
        }

        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #000;
            margin: 20px;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 20px;
        }

        .logo-container {
            flex-shrink: 0;
        }

        .logo-container img {
            height: 80px;
            width: auto;
        }

        .company-info {
            flex: 1;
            text-align: center;
        }

        .company-name {
            font-size: 14px;
            font-weight: bold;
            margin-bottom: 2px;
            text-transform: uppercase;
        }

        .company-address {
            font-size: 10px;
            margin-bottom: 1px;
        }

        .document-title {
            font-size: 14px;
            font-weight: bold;
            margin: 20px 0;
            text-transform: uppercase;
            text-align: center;
            background-color: #000;
            color: #fff;
            padding: 10px;
        }

        .info-section {
            margin-bottom: 20px;
        }

        .info-row {
            margin-bottom: 8px;
            font-size: 12px;
        }

        .info-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin-bottom: 20px;
        }

        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            font-size: 11px;
        }

        .items-table th,
        .items-table td {
            border: 1px solid #000;
            padding: 5px 8px;
            text-align: left;
        }

        .items-table th {
            font-weight: bold;
            background-color: #f0f0f0;
        }

        .items-table td.text-center {
            text-align: center;
        }

        .items-table td.text-right {
            text-align: right;
        }

        .status-badge {
            display: inline-block;
            padding: 2px 8px;
            border-radius: 3px;
            font-size: 10px;
            font-weight: bold;
        }

        .status-pending {
            background-color: #fff3cd;
            color: #856404;
        }

        .status-completed {
            background-color: #d4edda;
            color: #155724;
        }

        .status-cancelled {
            background-color: #f8d7da;
            color: #721c24;
        }

        .footer {
            margin-top: 40px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }

        .print-btn {
            background-color: #007bff;
            color: white;
            border: none;
            padding: 10px 20px;
            cursor: pointer;
            border-radius: 4px;
            margin-bottom: 20px;
        }

        .print-btn:hover {
            background-color: #0056b3;
        }

        .signatures-section {
            margin-top: 40px;
            display: flex;
            justify-content: space-between;
            font-size: 12px;
            font-weight: bold;
        }

        .signature-box {
            text-align: center;
            width: 30%;
        }
    </style>
</head>
<body>
    <div class="no-print">
        <button onclick="window.print()" class="print-btn">🖨️ Print</button>
        <button onclick="window.close()" class="print-btn" style="background-color: #6c757d;">✕ Close</button>
    </div>

    <!-- Header -->
    <div class="header">
        <div class="logo-container">
            <img src="<?php echo e(asset('images/site_logo.png')); ?>" alt="Company Logo">
        </div>
        <div class="company-info">
            <div class="company-name">ISAM KABBANI & PARTNERS FOR CONSTRUCTION & MAINT. CO. ( L.L.C )</div>
            <div class="company-address">Dubai: Dubai Industrial City, Jebel Ali Tel# 04 818 1900; Fax# 04 429 7031</div>
            <div class="company-address">E-mail : dubai@kcgemirates.ae; abudhabi@kcgemirates.ae   Website : www.ikkgroup.com</div>
        </div>
    </div>

    <!-- Document Title -->
    <div class="document-title">MATERIAL SITE TRANSFER NOTE</div>

    <!-- Transfer Information -->
    <div class="info-grid">
        <div>
            <div class="info-row">
                <strong>Transfer #:</strong> <?php echo e($siteTransfer->transfer_number ?? 'ST-' . str_pad($siteTransfer->id, 5, '0', STR_PAD_LEFT)); ?>

            </div>
            <div class="info-row">
                <strong>Transfer Date:</strong> <?php echo e($siteTransfer->transfer_date ? $siteTransfer->transfer_date->format('d/m/Y') : 'N/A'); ?>

            </div>
            <div class="info-row">
                <strong>From Project:</strong> <?php echo e($siteTransfer->fromProject ? ($siteTransfer->fromProject->project_number . ' - ' . $siteTransfer->fromProject->project_name) : 'N/A'); ?>

            </div>
        </div>
        <div>
            <div class="info-row">
                <strong>To Project:</strong> <?php echo e($siteTransfer->toProject ? ($siteTransfer->toProject->project_number . ' - ' . $siteTransfer->toProject->project_name) : 'N/A'); ?>

            </div>
            <div class="info-row">
                <strong>Transferred By:</strong> <?php echo e($siteTransfer->transferredBy->name ?? 'N/A'); ?>

            </div>
            <div class="info-row">
                <strong>Status:</strong>
                <span class="status-badge status-<?php echo e(strtolower($siteTransfer->status)); ?>">
                    <?php echo e(ucfirst($siteTransfer->status)); ?>

                </span>
            </div>
        </div>
    </div>

    <?php if($siteTransfer->notes): ?>
    <div class="info-section">
        <div class="info-row">
            <strong>Notes:</strong> <?php echo e($siteTransfer->notes); ?>

        </div>
    </div>
    <?php endif; ?>

    <!-- Items Table -->
    <table class="items-table">
        <thead>
            <tr>
                <th style="width: 5%;">Sr.</th>
                <th style="width: 12%;">Item Code</th>
                <th style="width: 35%;">Description</th>
                <th style="width: 10%;">Quantity</th>
                <th style="width: 8%;">Unit</th>
                <th style="width: 15%;">Unit Price</th>
                <th style="width: 15%;">Total Price</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $siteTransfer->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td class="text-center"><?php echo e($index + 1); ?></td>
                <td class="text-center"><?php echo e($item->item->item_code ?? 'NO-CODE'); ?></td>
                <td><?php echo e($item->item->item_description ?? 'Unknown Item'); ?></td>
                <td class="text-center"><?php echo e(number_format($item->quantity_transferred, 0)); ?></td>
                <td class="text-center"><?php echo e(strtoupper($item->item->unit_of_measure ?? 'PCS')); ?></td>
                <td class="text-right"><?php echo e(number_format($item->unit_price, 2)); ?></td>
                <td class="text-right"><?php echo e(number_format($item->total_price, 2)); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="7" class="text-center">No items found</td>
            </tr>
            <?php endif; ?>
        </tbody>
        <?php if($siteTransfer->items->count() > 0): ?>
        <tfoot>
            <tr style="font-weight: bold;">
                <td colspan="3" class="text-right">TOTAL:</td>
                <td class="text-center"><?php echo e(number_format($siteTransfer->items->sum('quantity_transferred'), 0)); ?></td>
                <td></td>
                <td></td>
                <td class="text-right">AED <?php echo e(number_format($siteTransfer->total_value, 2)); ?></td>
            </tr>
        </tfoot>
        <?php endif; ?>
    </table>

    <!-- Signatures Section -->
    <div class="signatures-section">
        <div class="signature-box">From Project Manager</div>
        <div class="signature-box">Warehouse Manager</div>
        <div class="signature-box">To Project Manager</div>
    </div>

    <!-- Footer -->
    <div class="footer">
        <p>Generated on <?php echo e(now()->format('d/m/Y H:i')); ?></p>
    </div>

    <script>
        // Auto-print when page loads
        window.addEventListener('load', function() {
            setTimeout(() => {
                if (window.opener) {
                    window.print();
                }
            }, 500);
        });

        // Close window after printing
        window.addEventListener('afterprint', function() {
            if (window.opener) {
                setTimeout(() => {
                    window.close();
                }, 500);
            }
        });
    </script>
</body>
</html><?php /**PATH /home/kcg/public_html/wms.kcguae.com/resources/views/warehouse/site-transfers/print-single.blade.php ENDPATH**/ ?>