<?php $__env->startSection('title', $item->item_description); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('warehouse.items.index')); ?>">Items</a></li>
    <li class="breadcrumb-item active"><?php echo e($item->item_code); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1"><?php echo e($item->item_description); ?></h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Item Code: <?php echo e($item->item_code); ?></p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <a href="<?php echo e(route('warehouse.items.index')); ?>" class="btn btn-sm btn-outline-secondary">
                <i class="material-icons mr-1" style="font-size: 16px;">arrow_back</i>
                Back to List
            </a>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Item Information -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Item Information</h6>
        </div>

        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <h6 class="text-primary font-weight-bold mb-3">Basic Information</h6>
                    <dl class="row">
                        <dt class="col-sm-4 text-muted">Item Code</dt>
                        <dd class="col-sm-8"><?php echo e($item->item_code); ?></dd>

                        <dt class="col-sm-4 text-muted">Item Description</dt>
                        <dd class="col-sm-8"><?php echo e($item->item_description); ?></dd>

                        <dt class="col-sm-4 text-muted">Category</dt>
                        <dd class="col-sm-8">
                            <?php if($item->category): ?>
                                <a href="<?php echo e(route('warehouse.item-categories.show', $item->category->id)); ?>">
                                    <?php echo e($item->category->category_name); ?>

                                </a>
                            <?php else: ?>
                                <span class="text-muted">No category assigned</span>
                            <?php endif; ?>
                        </dd>

                        <dt class="col-sm-4 text-muted">Unit of Measure</dt>
                        <dd class="col-sm-8"><?php echo e($item->unit ? $item->unit->display_name : $item->unit_of_measure); ?></dd>

                        <dt class="col-sm-4 text-muted">Status</dt>
                        <dd class="col-sm-8">
                            <?php if($item->status === 'active'): ?>
                                <span class="badge badge-success">Active</span>
                            <?php elseif($item->status === 'inactive'): ?>
                                <span class="badge badge-secondary">Inactive</span>
                            <?php else: ?>
                                <span class="badge badge-warning"><?php echo e(ucfirst($item->status)); ?></span>
                            <?php endif; ?>
                        </dd>

                        <dt class="col-sm-4 text-muted">Created Date</dt>
                        <dd class="col-sm-8"><?php echo e($item->created_at->format('M d, Y H:i')); ?></dd>

                        <dt class="col-sm-4 text-muted">Last Updated</dt>
                        <dd class="col-sm-8"><?php echo e($item->updated_at->format('M d, Y H:i')); ?></dd>
                    </dl>
                </div>

                <div class="col-md-6">
                    <h6 class="text-primary font-weight-bold mb-3">Stock Information</h6>
                    <dl class="row">
                        <dt class="col-sm-4 text-muted">Min Stock Level</dt>
                        <dd class="col-sm-8"><?php echo e($item->min_stock_level ?: 'Not set'); ?></dd>

                        <dt class="col-sm-4 text-muted">Max Stock Level</dt>
                        <dd class="col-sm-8"><?php echo e($item->max_stock_level ?: 'Not set'); ?></dd>

                        <dt class="col-sm-4 text-muted">Reorder Point</dt>
                        <dd class="col-sm-8"><?php echo e($item->reorder_point ?: 'Not set'); ?></dd>

                        <dt class="col-sm-4 text-muted">Current Stock</dt>
                        <dd class="col-sm-8">
                            <?php
                                $totalStock = $item->inventories->sum('quantity_available');
                            ?>
                            <span class="badge badge-info"><?php echo e($totalStock); ?> <?php echo e($item->unit ? $item->unit->unit_symbol : $item->unit_of_measure); ?></span>
                        </dd>

                        <dt class="col-sm-4 text-muted">Stock Locations</dt>
                        <dd class="col-sm-8">
                            <span class="badge badge-primary"><?php echo e($item->inventories->count()); ?> location(s)</span>
                        </dd>
                    </dl>

                    <?php if($item->notes): ?>
                        <h6 class="text-primary font-weight-bold mb-3 mt-4">Notes</h6>
                        <p class="text-muted"><?php echo e($item->notes); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <?php if($item->stockMovements->count() > 0): ?>
    <!-- Recent Stock Movements -->
    <div class="card shadow">
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-primary">Recent Stock Movements</h6>
            <small class="text-muted">Last 10 movements</small>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Type</th>
                            <th>Quantity</th>
                            <th>Reference</th>
                            <th>Notes</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $item->stockMovements->take(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($movement->created_at->format('M d, Y H:i')); ?></td>
                            <td>
                                <?php if($movement->movement_type === 'in'): ?>
                                    <span class="badge badge-success">Stock In</span>
                                <?php else: ?>
                                    <span class="badge badge-danger">Stock Out</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($movement->movement_type === 'in'): ?>
                                    <span class="text-success">+<?php echo e($movement->quantity); ?></span>
                                <?php else: ?>
                                    <span class="text-danger">-<?php echo e($movement->quantity); ?></span>
                                <?php endif; ?>
                                <?php echo e($item->unit ? $item->unit->unit_symbol : $item->unit_of_measure); ?>

                            </td>
                            <td><?php echo e($movement->reference_number ?? 'N/A'); ?></td>
                            <td><?php echo e($movement->notes ?? 'No notes'); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/kcg/public_html/wms.kcguae.com/resources/views/warehouse/items/show.blade.php ENDPATH**/ ?>