<?php $__env->startSection('title', 'Material Requests'); ?>

<?php $__env->startSection('meta'); ?>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item">Inventory</li>
    <li class="breadcrumb-item active">Material Requests</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Material Requests</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Track and manage material requests from inventory</p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.outgoing.create')): ?>
            <a href="<?php echo e(route('warehouse.outgoing.create')); ?>" class="btn btn-sm btn-primary">
                <i class="fas fa-plus mr-1"></i>
                Create New Material Request
            </a>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <!-- Statistics Cards -->
    <div class="row mb-4 warehouse-stats-row">
        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Requests','value' => $stats['total_requests'] ?? 25,'icon' => 'assignment','color' => 'primary','subtitle' => 'All material requests']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Requests','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($stats['total_requests'] ?? 25),'icon' => 'assignment','color' => 'primary','subtitle' => 'All material requests']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Pending','value' => $stats['pending'] ?? 8,'icon' => 'pending','color' => 'warning','subtitle' => 'Awaiting approval']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Pending','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($stats['pending'] ?? 8),'icon' => 'pending','color' => 'warning','subtitle' => 'Awaiting approval']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Successful','value' => $stats['dispatched'] ?? 12,'icon' => 'check_circle','color' => 'success','subtitle' => 'Successfully dispatched']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Successful','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($stats['dispatched'] ?? 12),'icon' => 'check_circle','color' => 'success','subtitle' => 'Successfully dispatched']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Canceled','value' => $stats['cancelled'] ?? 3,'icon' => 'cancel','color' => 'danger','subtitle' => 'Canceled requests']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Canceled','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($stats['cancelled'] ?? 3),'icon' => 'cancel','color' => 'danger','subtitle' => 'Canceled requests']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
    </div>

    <!-- Filters Panel -->
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0">
                <i class="material-icons mr-2">filter_list</i>
                Filters
            </h6>
        </div>
        <div class="card-body">
            <div class="row align-items-center">
                <div class="col-md-3">
                    <div style="font-size: 12px; margin-bottom: 8px;">
                        <label for="filter_status" class="form-label">Status</label>
                        <select name="filter_status" id="filter_status" class="form-control form-control-sm">
                            <option value="">All Status</option>
                            <option value="pending">Pending</option>
                            <option value="successful">Successful</option>
                            <option value="canceled">Canceled</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div style="font-size: 12px; margin-bottom: 8px;">
                        <label for="filter_date_from" class="form-label">Date From</label>
                        <input type="date" id="filter_date_from" class="form-control form-control-sm">
                    </div>
                </div>
                <div class="col-md-3">
                    <div style="font-size: 12px; margin-bottom: 8px;">
                        <label for="filter_date_to" class="form-label">Date To</label>
                        <input type="date" id="filter_date_to" class="form-control form-control-sm">
                    </div>
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <div class="form-group w-100">
                        <button onclick="applyFilters()" class="btn btn-primary btn-sm mr-2">
                            <i class="material-icons mr-1" style="font-size: 16px;">search</i>
                            Apply Filters
                        </button>
                        <button onclick="clearFilters()" class="btn btn-outline-secondary btn-sm">
                            <i class="material-icons mr-1" style="font-size: 16px;">clear</i>
                            Clear
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Material Requests Table -->
    <div class="card">
        <div class="card-header warehouse-report-header">
            <h5 class="mb-0 warehouse-report-title">
                <i class="material-icons align-middle mr-2">assignment</i>
                Material Requests
            </h5>
        </div>
        <div class="card-body p-0">
            <div class="warehouse-table-container">
                <!-- Loading Overlay -->
                <div class="warehouse-loading-overlay" id="tableLoadingOverlay">
                    <div class="warehouse-loading-content">
                        <div class="text-center">
                            <div class="spinner-border text-primary" role="status">
                                <span class="sr-only">Loading...</span>
                            </div>
                            <div class="mt-2">Loading material request data...</div>
                        </div>
                    </div>
                </div>

                <!-- Table -->
                <div class="warehouse-table-wrapper">
                    <table id="materialRequestsTable" class="table table-hover mb-0 warehouse-table">
                        <thead class="thead-light">
                            <tr>
                                <th style="min-width: 120px;">Reference</th>
                                <th style="min-width: 100px;">Date</th>
                                <th style="min-width: 150px;">Project</th>
                                <th style="min-width: 120px;">Division</th>
                                <th style="min-width: 150px;">Requested By</th>
                                <th style="min-width: 80px;">Items</th>
                                <th style="min-width: 100px;">Status</th>
                                <th style="min-width: 130px;">Dispatch Status</th>
                                <th style="min-width: 120px;">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Data will be loaded via AJAX -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- View Details Modal -->
    <div class="modal fade" id="viewDetailsModal" tabindex="-1" role="dialog" aria-labelledby="viewDetailsModalLabel" aria-hidden="true" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="viewDetailsModalLabel">
                        <i class="material-icons align-middle mr-1">assignment</i>
                        Material Request Details
                    </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div id="requestDetailsContent">
                        <!-- Content will be loaded dynamically -->
                        <div class="text-center py-4">
                            <i class="material-icons text-muted" style="font-size: 48px;">assignment</i>
                            <div class="text-muted">Loading request details...</div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('admin-assets/css/warehouse-reports.css')); ?>">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap4.min.css">
    <style>
        /* Adjust Select2 dropdown widths for better proportions */
        .select2-container {
            width: 100% !important;
        }

        /* Make dropdowns auto-width based on content */
        .select2-dropdown {
            min-width: 200px;
            max-width: 400px;
            width: auto !important;
        }

        /* Ensure the selection box doesn't get too wide */
        .select2-container .select2-selection--single {
            min-width: 200px;
            max-width: 100%;
        }

        /* Allow dropdown to expand based on content */
        .select2-container--open .select2-dropdown--below {
            width: auto !important;
            min-width: 200px;
        }
        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            background-color: #f8f9fa;
        }

        .table-responsive {
            border-radius: 0.375rem;
        }

        .status-badge {
            display: inline-flex;
            align-items: center;
            padding: 0.25rem 0.75rem;
            font-size: 0.75rem;
            font-weight: 500;
            line-height: 1;
            border-radius: 0.375rem;
        }

        .status-pending {
            color: #856404;
            background-color: #fff3cd;
            border: 1px solid #ffeaa7;
        }

        .status-dispatched {
            color: #155724;
            background-color: #d4edda;
            border: 1px solid #c3e6cb;
        }

        .status-cancelled {
            color: #721c24;
            background-color: #f8d7da;
            border: 1px solid #f5c6cb;
        }

        /* Modal positioning fixes */
        .modal {
            z-index: 1050 !important;
        }

        .modal-backdrop {
            z-index: 1040 !important;
        }

        .modal-dialog-centered {
            display: flex;
            align-items: center;
            min-height: calc(100% - 1rem);
        }

        .modal-content {
            position: relative;
            width: 100%;
            margin: 1.75rem auto;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('admin-assets/js/warehouse-reports.js')); ?>"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap4.min.js"></script>
<script>
let materialRequestsTable;

$(document).ready(function() {
    initializeDataTable();

    // Entries per page change handler
    $('#entries-per-page').change(function() {
        materialRequestsTable.page.len($(this).val()).draw();
    });
});

function initializeDataTable() {
    materialRequestsTable = $('#materialRequestsTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '<?php echo e(route('warehouse.inventory.material-requests')); ?>',
            data: function(d) {
                d.status = $('#filter_status').val();
                d.date_from = $('#filter_date_from').val();
                d.date_to = $('#filter_date_to').val();
                d.project = $('#filter_project').val();
            }
        },
        columns: [
            {
                data: 'request_number',
                name: 'request_number',
                render: function(data) {
                    return `<strong>${data}</strong>`;
                }
            },
            {
                data: 'date',
                name: 'date',
                render: function(data) {
                    return data;
                }
            },
            {
                data: 'project',
                name: 'project',
                render: function(data) {
                    return data || '<span class="text-muted">N/A</span>';
                }
            },
            {
                data: 'division',
                name: 'division',
                render: function(data) {
                    return data || '<span class="text-muted">N/A</span>';
                }
            },
            {
                data: 'requester',
                name: 'requester',
                render: function(data) {
                    return data || '<span class="text-muted">N/A</span>';
                }
            },
            {
                data: 'items_count',
                name: 'items_count',
                render: function(data) {
                    return `<span class="badge badge-light">${data} items</span>`;
                }
            },
            {
                data: 'status',
                name: 'status',
                render: function(data, type, row) {
                    let badgeClass = 'badge-secondary';
                    let icon = 'info';

                    switch(data.label.toLowerCase()) {
                        case 'pending':
                            badgeClass = 'badge-warning';
                            icon = 'pending';
                            break;
                        case 'successful':
                            badgeClass = 'badge-success';
                            icon = 'check_circle';
                            break;
                        case 'canceled':
                            badgeClass = 'badge-danger';
                            icon = 'cancel';
                            break;
                    }

                    return `<span class="badge ${badgeClass}">
                        <i class="material-icons" style="font-size: 12px;">${icon}</i>
                        ${data.label}
                    </span>`;
                }
            },
            {
                data: 'dispatch_status',
                name: 'dispatch_status',
                render: function(data, type, row) {
                    if (!data) {
                        return '<span class="badge badge-light"><i class="material-icons" style="font-size: 12px;">hourglass_empty</i> Pending</span>';
                    }

                    let badgeClass = 'badge-light';
                    let icon = 'hourglass_empty';
                    let label = 'Pending';

                    switch(data.toLowerCase()) {
                        case 'fully_dispatched':
                            badgeClass = 'badge-success';
                            icon = 'check_circle';
                            label = 'Fully Dispatched';
                            break;
                        case 'partially_dispatched':
                            badgeClass = 'badge-warning';
                            icon = 'schedule';
                            label = 'Partially Dispatched';
                            break;
                        case 'pending':
                        default:
                            badgeClass = 'badge-light';
                            icon = 'hourglass_empty';
                            label = 'Pending';
                            break;
                    }

                    return `<span class="badge ${badgeClass}">
                        <i class="material-icons" style="font-size: 12px;">${icon}</i>
                        ${label}
                    </span>`;
                }
            },
            {
                data: 'actions',
                name: 'actions',
                orderable: false,
                searchable: false,
                render: function(data) {
                    return data;
                }
            }
        ],
        order: [[1, 'desc']],
        pageLength: 25,
        lengthMenu: [[10, 25, 50, 100], [10, 25, 50, 100]],
        language: {
            processing: '<div class="text-center"><div class="spinner-border text-primary" role="status"><span class="sr-only">Loading...</span></div></div>',
            emptyTable: 'No material requests found',
            zeroRecords: 'No matching material requests found'
        },
        drawCallback: function(settings) {
            $('#entries-per-page').val(settings._iDisplayLength);
        }
    });
}

function applyFilters() {
    materialRequestsTable.draw();
}

function clearFilters() {
    $('#filter_status, #filter_date_from, #filter_date_to, #filter_project').val('');
    materialRequestsTable.draw();
}

// Action functions
function dispatchRequest(id) {
    // Redirect to approval/dispatch page
    window.location.href = `/warehouse/inventory/material-requests/${id}/dispatch`;
}

function cancelRequest(id) {
    if (confirm('Are you sure you want to cancel this material request? This action cannot be undone.')) {
        // Send AJAX request to cancel the request
        fetch(`/warehouse/inventory/material-requests/${id}/dispatch`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({
                action: 'cancel'
            })
        })
        .then(response => {
            if (response.ok) {
                // Reload table after successful cancellation
                materialRequestsTable.ajax.reload();

                // Show success message
                showAlert('Material request cancelled successfully!', 'success');
            } else {
                showAlert('Failed to cancel material request. Please try again.', 'danger');
            }
        })
        .catch(error => {
            console.error('Error cancelling request:', error);
            showAlert('Failed to cancel material request. Please try again.', 'danger');
        });
    }
}

function viewRequest(id) {
    console.log('viewRequest called with id:', id);

    // Hide any existing modals first
    $('.modal').modal('hide');

    // Wait a moment then show the new modal
    setTimeout(() => {
        // Load request details in modal
        $('#viewDetailsModal').modal({
            backdrop: 'static',
            keyboard: true,
            show: true
        });

        // Ensure modal appears in correct position
        $('#viewDetailsModal').on('shown.bs.modal', function () {
            $(this).css('z-index', 1050);
            $('.modal-backdrop').css('z-index', 1040);
        });

        // Show loading state
        $('#requestDetailsContent').html(`
            <div class="text-center py-4">
                <div class="spinner-border text-primary" role="status">
                    <span class="sr-only">Loading...</span>
                </div>
                <div class="text-muted mt-2">Loading request details...</div>
            </div>
        `);

        // Fetch request details after modal is shown
        const url = `/warehouse/inventory/material-requests/${id}`;
        console.log('Making request to:', url);

        fetch(url, {
        method: 'GET',
        headers: {
            'Accept': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]') ? document.querySelector('meta[name="csrf-token"]').getAttribute('content') : '<?php echo e(csrf_token()); ?>'
        }
    })
    .then(response => {
        console.log('Response status:', response.status);
        console.log('Response headers:', response.headers);

        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }
        return response.json();
    })
    .then(data => {
        console.log('Response data:', data);

        if (data.success) {
            const request = data.data;
            $('#requestDetailsContent').html(`
                <div class="row mb-3">
                    <div class="col-md-6">
                        <strong>Request Number:</strong><br>
                        <span class="text-primary">${request.request_number}</span>
                    </div>
                    <div class="col-md-6">
                        <strong>Date:</strong><br>
                        ${request.request_date}
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <strong>Project:</strong><br>
                        ${request.project}
                    </div>
                    <div class="col-md-6">
                        <strong>Requested By:</strong><br>
                        ${request.requested_by}
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-12">
                        <strong>Items:</strong>
                        <div class="table-responsive mt-2">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Code</th>
                                        <th>Description</th>
                                        <th>Unit</th>
                                        <th>Requested</th>
                                        <th>Available</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    ${request.items.map(item => `
                                        <tr>
                                            <td>${item.item_code}</td>
                                            <td>${item.description}</td>
                                            <td>${item.unit}</td>
                                            <td>${item.quantity_requested}</td>
                                            <td>${item.quantity_available}</td>
                                        </tr>
                                    `).join('')}
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            `);
        } else {
            $('#requestDetailsContent').html(`
                <div class="alert alert-danger">
                    Error loading request details: ${data.message || 'Unknown error'}
                </div>
            `);
        }
    })
    .catch(error => {
        console.error('Fetch error:', error);
        $('#requestDetailsContent').html(`
            <div class="alert alert-danger">
                Error loading request details: ${error.message}<br>
                <small>Check console for more details</small>
            </div>
        `);
    });
    }, 100);
}

function deleteRequest(id) {
    if (confirm('Are you sure you want to delete this material request? This action cannot be undone.')) {
        fetch(`<?php echo e(route('warehouse.inventory.material-requests', '')); ?>/${id}`, {
            method: 'DELETE',
            headers: {
                'Accept': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showAlert('Material request deleted successfully!', 'success');
                materialRequestsTable.ajax.reload();
            } else {
                showAlert('Error: ' + (data.message || 'Failed to delete request'), 'danger');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showAlert('Error deleting material request. Please try again.', 'danger');
        });
    }
}

function showAlert(message, type) {
    const alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
    const alert = `
        <div class="alert ${alertClass} alert-dismissible fade show position-fixed" style="top: 20px; right: 20px; z-index: 9999;">
            ${message}
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
    `;
    $('body').append(alert);
    setTimeout(() => $('.alert').alert('close'), 5000);
}

function printMaterialRequest(id) {
    console.log('printMaterialRequest called with id:', id);

    // Open print view in new window - using Laravel route helper
    const printUrl = '<?php echo e(route("warehouse.inventory.material-requests.print", ":id")); ?>'.replace(':id', id);
    console.log('Opening print URL:', printUrl);
    const printWindow = window.open(printUrl, '_blank', 'width=800,height=600,scrollbars=yes,resizable=yes');

    if (printWindow) {
        printWindow.focus();

        // Wait for content to load then print
        printWindow.addEventListener('load', function() {
            setTimeout(() => {
                printWindow.print();
            }, 1000);
        });
    } else {
        // Fallback: navigate to print page if popup blocked
        window.open(printUrl, '_blank');
    }
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/kcg/public_html/wms.kcguae.com/resources/views/warehouse/inventory/material-requests.blade.php ENDPATH**/ ?>