<?php $__env->startSection('title', 'Site Return Report'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('warehouse.reports.index')); ?>">Reports</a></li>
    <li class="breadcrumb-item active">Site Return</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title-left">
        <h3 class="mb-1">Site Return Report</h3>
        <p class="text-muted mb-0" style="font-size: 13px;">Site returns and material return tracking</p>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Statistics Cards -->
    <div class="row mb-4 warehouse-stats-row">
        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Returns','value' => $returnItems->total(),'icon' => 'assignment_return','color' => 'warning','subtitle' => 'All returned items']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Returns','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($returnItems->total()),'icon' => 'assignment_return','color' => 'warning','subtitle' => 'All returned items']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Quantity','value' => number_format($returnItems->getCollection()->sum('quantity'), 2),'icon' => 'inventory_2','color' => 'info','subtitle' => 'Total quantity returned']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Quantity','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(number_format($returnItems->getCollection()->sum('quantity'), 2)),'icon' => 'inventory_2','color' => 'info','subtitle' => 'Total quantity returned']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Value','value' => 'AED ' . number_format($returnItems->getCollection()->sum('total_price'), 2),'icon' => 'attach_money','color' => 'danger','subtitle' => 'Total value of returns','showDirham' => true]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Value','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('AED ' . number_format($returnItems->getCollection()->sum('total_price'), 2)),'icon' => 'attach_money','color' => 'danger','subtitle' => 'Total value of returns','showDirham' => true]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Quality Passed','value' => collect($returnItems->getCollection())->where('quality_status', 'passed')->count(),'icon' => 'verified','color' => 'success','subtitle' => 'Items passed quality check']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Quality Passed','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(collect($returnItems->getCollection())->where('quality_status', 'passed')->count()),'icon' => 'verified','color' => 'success','subtitle' => 'Items passed quality check']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
    </div>

    <!-- Division Breakdown Card -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0 d-flex align-items-center">
                        <i class="material-icons mr-2">business</i>
                        Returns by Division
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <?php if(isset($divisionBreakdown) && $divisionBreakdown->count() > 0): ?>
                            <?php $__currentLoopData = $divisionBreakdown->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
                                <div class="text-center">
                                    <div class="h5 mb-1 text-danger">
                                        <span class="dirham-symbol-inline"><?php echo e(number_format($division['total_value'], 0)); ?></span>
                                    </div>
                                    <div class="small text-muted"><?php echo e($division['division']); ?></div>
                                    <div class="small text-info"><?php echo e($division['item_count']); ?> returns (<?php echo e(number_format($division['total_quantity'], 2)); ?> qty)</div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <div class="col-12">
                                <div class="text-center text-muted py-3">
                                    <i class="material-icons" style="font-size: 48px; opacity: 0.3;">business</i>
                                    <p class="mb-0 mt-2">No division data available for returns</p>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters Panel -->
    <div class="card mb-4 warehouse-filters-panel">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="material-icons align-middle mr-2">filter_list</i>
                Filters
            </h5>
        </div>
        <div class="card-body">
            <form id="filterForm" class="warehouse-filter-form" method="GET" action="<?php echo e(route('warehouse.reports.returns')); ?>">
                <div class="row">
                    <div class="col-md-2 mb-3">
                        <label class="form-label">Search</label>
                        <input type="text" name="search" value="<?php echo e(request('search')); ?>" class="form-control" 
                               placeholder="Item code, description">
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Project</label>
                        <select name="project_id" class="form-control warehouse-select2" data-placeholder="All Projects">
                            <option value="">All Projects</option>
                            <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($project->id); ?>" <?php echo e(request('project_id') == $project->id ? 'selected' : ''); ?>>
                                    <?php echo e($project->project_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Division</label>
                        <select name="division_id" class="form-control warehouse-select2" data-placeholder="All Divisions">
                            <option value="">All Divisions</option>
                            <?php $__currentLoopData = $divisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($division->id); ?>" <?php echo e(request('division_id') == $division->id ? 'selected' : ''); ?>>
                                    <?php echo e($division->division_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Category</label>
                        <select name="category_id" class="form-control warehouse-select2" data-placeholder="All Categories">
                            <option value="">All Categories</option>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>" <?php echo e(request('category_id') == $category->id ? 'selected' : ''); ?>>
                                    <?php echo e($category->category_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Quality Status</label>
                        <select name="quality_status" class="form-control warehouse-select2" data-placeholder="All Quality Status">
                            <option value="">All Quality Status</option>
                            <?php $__currentLoopData = $qualityStatuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($status); ?>" <?php echo e(request('quality_status') == $status ? 'selected' : ''); ?>>
                                    <?php echo e(ucfirst($status)); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">&nbsp;</label>
                        <button type="submit" class="btn btn-primary btn-block">
                            <i class="material-icons" style="font-size: 18px; vertical-align: middle;">search</i>
                            Apply
                        </button>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-2 mb-3">
                        <label class="form-label">Date From</label>
                        <input type="date" name="date_from" value="<?php echo e(request('date_from')); ?>" class="form-control warehouse-datepicker">
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Date To</label>
                        <input type="date" name="date_to" value="<?php echo e(request('date_to')); ?>" class="form-control warehouse-datepicker">
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Export Buttons -->
    <div class="row warehouse-export-buttons">
        <div class="col-12 text-right">
            <button class="btn btn-success warehouse-export-btn" data-export="excel">
                <i class="material-icons" style="font-size: 18px; vertical-align: middle;">download</i>
                Export Excel
            </button>
            <button class="btn btn-info warehouse-export-btn" data-export="pdf">
                <i class="material-icons" style="font-size: 18px; vertical-align: middle;">picture_as_pdf</i>
                Export PDF
            </button>
            <button class="btn btn-secondary warehouse-export-btn" data-action="print">
                <i class="material-icons" style="font-size: 18px; vertical-align: middle;">print</i>
                Print
            </button>
        </div>
    </div>

    <!-- Site Return Report Table -->
    <div class="card">
        <div class="card-header warehouse-report-header">
            <h5 class="mb-0 warehouse-report-title">
                <i class="material-icons align-middle mr-2">assignment_return</i>
                Site Return Report (<?php echo e($returnItems->total()); ?> total returns)
            </h5>
        </div>
        <div class="card-body p-0">
            <div class="warehouse-table-container">
                <!-- Loading Overlay -->
                <div class="warehouse-loading-overlay" id="tableLoadingOverlay">
                    <div class="warehouse-loading-content">
                        <div class="text-center">
                            <div class="spinner-border text-primary" role="status">
                                <span class="sr-only">Loading...</span>
                            </div>
                            <div class="mt-2">Loading return data...</div>
                        </div>
                    </div>
                </div>

                <!-- Table -->
                <div class="warehouse-table-wrapper">
                    <table class="table table-hover mb-0 warehouse-table">
                        <thead class="thead-light">
                            <tr>
                                <th style="min-width: 150px;">Reference Number</th>
                                <th style="min-width: 120px;">Reference Type</th>
                                <th style="min-width: 180px;">Project</th>
                                <th style="min-width: 120px;">Division</th>
                                <th style="min-width: 120px;">Item Code</th>
                                <th style="min-width: 200px;">Description</th>
                                <th style="min-width: 100px;">Category</th>
                                <th style="min-width: 80px;" class="text-right">Quantity</th>
                                <th style="min-width: 100px;" class="text-right">Unit Price</th>
                                <th style="min-width: 100px;" class="text-right">Total Price</th>
                                <th style="min-width: 100px;" class="text-center">Quality Status</th>
                                <th style="min-width: 100px;" class="text-center">Return Date</th>
                                <th style="min-width: 80px;" class="text-center">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $returnItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td class="warehouse-cell-nowrap"><?php echo e($item->reference_number ?? '-'); ?></td>
                                    <td>
                                        <?php if($item->reference_type == 'Material Request'): ?>
                                            <span class="badge warehouse-badge warehouse-status-success"><?php echo e($item->reference_type); ?></span>
                                        <?php elseif($item->reference_type == 'Direct Delivery'): ?>
                                            <span class="badge warehouse-badge warehouse-status-info"><?php echo e($item->reference_type); ?></span>
                                        <?php elseif($item->reference_type == 'Material Transfer'): ?>
                                            <span class="badge warehouse-badge warehouse-status-warning"><?php echo e($item->reference_type); ?></span>
                                        <?php else: ?>
                                            <span class="badge warehouse-badge warehouse-status-secondary"><?php echo e($item->reference_type); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e(Str::limit($item->project_name ?? '-', 25)); ?></td>
                                    <td><?php echo e($item->division ?? '-'); ?></td>
                                    <td class="warehouse-cell-nowrap"><?php echo e($item->item_code); ?></td>
                                    <td><?php echo e(Str::limit($item->item_description, 30)); ?></td>
                                    <td>
                                        <span class="badge warehouse-badge warehouse-status-secondary">
                                            <?php echo e($item->type_of_goods ?? 'No Category'); ?>

                                        </span>
                                    </td>
                                    <td class="text-right warehouse-cell-number">
                                        <strong><?php echo e(number_format($item->quantity, 2)); ?></strong>
                                    </td>
                                    <td class="text-right warehouse-cell-currency">
                                        AED <?php echo e(number_format($item->unit_price, 2)); ?>

                                    </td>
                                    <td class="text-right warehouse-cell-currency">
                                        <strong class="text-danger">AED <?php echo e(number_format($item->total_price, 2)); ?></strong>
                                    </td>
                                    <td class="warehouse-cell-status">
                                        <span class="badge warehouse-badge warehouse-status-<?php echo e($item->quality_status === 'passed' ? 'success' :
                                            ($item->quality_status === 'failed' ? 'danger' : 
                                            ($item->quality_status === 'conditional' ? 'warning' : 'info'))); ?>">
                                            <?php echo e(ucfirst($item->quality_status ?? 'pending')); ?>

                                        </span>
                                    </td>
                                    <td class="text-center warehouse-cell-date">
                                        <?php echo e($item->operation_date ? \Carbon\Carbon::parse($item->operation_date)->format('d M Y') : '-'); ?>

                                    </td>
                                    <td class="text-center">
                                        <a href="#" class="btn btn-sm btn-outline-primary warehouse-action-btn">
                                            <i class="material-icons">visibility</i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="13" class="warehouse-empty-state">
                                        <i class="material-icons">assignment_return</i>
                                        <h5>No Return Records Found</h5>
                                        <p class="text-muted">No returns match your current filters.</p>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        
        <?php if($returnItems->hasPages()): ?>
            <div class="card-footer">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        Showing <?php echo e($returnItems->firstItem()); ?> to <?php echo e($returnItems->lastItem()); ?> 
                        of <?php echo e($returnItems->total()); ?> returns
                    </div>
                    <div>
                        <nav class="warehouse-pagination">
                            <?php echo e($returnItems->links('pagination::bootstrap-4')); ?>

                        </nav>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <link href="<?php echo e(asset('admin-assets/css/warehouse-reports.css')); ?>" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />
    <style>
        .select2-container--bootstrap-5 .select2-selection {
            min-height: 38px;
            border: 1px solid #ced4da;
        }
        .select2-container--bootstrap-5 .select2-selection--single .select2-selection__rendered {
            line-height: 36px;
        }
        .select2-container--bootstrap-5 .select2-selection--single .select2-selection__arrow {
            height: 36px;
        }
        .select2-container {
            width: 100% !important;
        }

        /* UAE Dirham Symbol */
        .dirham-symbol-inline {
            position: relative;
        }

        .dirham-symbol-inline::before {
            content: '';
            display: inline-block;
            width: 16px;
            height: 16px;
            margin-right: 4px;
            background-image: url("data:image/svg+xml,%3Csvg viewBox='0 0 1000 870' width='16' height='16' style='fill: currentColor;'%3E%3Cpath d='m88.3 1c0.4 0.6 2.6 3.3 4.7 5.9 15.3 18.2 26.8 47.8 33 85.1 4.1 24.5 4.3 32.2 4.3 125.6v87h-41.8c-38.2 0-42.6-0.2-50.1-1.7-11.8-2.5-24-9.2-32.2-17.8-6.5-6.9-6.3-7.3-5.9 13.6 0.5 17.3 0.7 19.2 3.2 28.6 4 14.9 9.5 26 17.8 35.9 11.3 13.6 22.8 21.2 39.2 26.3 3.5 1 10.9 1.4 37.1 1.6l32.7 0.5v43.3 43.4l-46.1-0.3-46.3-0.3-8-3.2c-9.5-3.8-13.8-6.6-23.1-14.9l-6.8-6.1 0.4 19.1c0.5 17.7 0.6 19.7 3.1 28.7 8.7 31.8 29.7 54.5 57.4 61.9 6.9 1.9 9.6 2 38.5 2.4l30.9 0.4v89.6c0 54.1-0.3 94-0.8 100.8-0.5 6.2-2.1 17.8-3.5 25.9-6.5 37.3-18.2 65.4-35 83.6l-3.4 3.7h169.1c101.1 0 176.7-0.4 187.8-0.9 19.5-1 63-5.3 72.8-7.4 3.1-0.6 8.9-1.5 12.7-2.1 8.1-1.2 21.5-4 40.8-8.9 27.2-6.8 52-15.3 76.3-26.1 7.6-3.4 29.4-14.5 35.2-18 3.1-1.8 6.8-4 8.2-4.7 3.9-2.1 10.4-6.3 19.9-13.1 4.7-3.4 9.4-6.7 10.4-7.4 4.2-2.8 18.7-14.9 25.3-21 25.1-23.1 46.1-48.8 62.4-76.3 2.3-4 5.3-9 6.6-11.1 3.3-5.6 16.9-33.6 18.2-37.8 0.6-1.9 1.4-3.9 1.8-4.3 2.6-3.4 17.6-50.6 19.4-60.9 0.6-3.3 0.9-3.8 3.4-4.3 1.6-0.3 24.9-0.3 51.8-0.1 53.8 0.4 53.8 0.4 65.7 5.9 6.7 3.1 8.7 4.5 16.1 11.2 9.7 8.7 8.8 10.1 8.2-11.7-0.4-12.8-0.9-20.7-1.8-23.9-3.4-12.3-4.2-14.9-7.2-21.1-9.8-21.4-26.2-36.7-47.2-44l-8.2-3-33.4-0.4-33.3-0.5 0.4-11.7c0.4-15.4 0.4-45.9-0.1-61.6l-0.4-12.6 44.6-0.2c38.2-0.2 45.3 0 49.5 1.1 12.6 3.5 21.1 8.3 31.5 17.8l5.8 5.4v-14.8c0-17.6-0.9-25.4-4.5-37-7.1-23.5-21.1-41-41.1-51.8-13-7-13.8-7.2-58.5-7.5-26.2-0.2-39.9-0.6-40.6-1.2-0.6-0.6-1.1-1.6-1.1-2.4 0-0.8-1.5-7.1-3.5-13.9-23.4-82.7-67.1-148.4-131-197.1-8.7-6.7-30-20.8-38.6-25.6-3.3-1.9-6.9-3.9-7.8-4.5-4.2-2.3-28.3-14.1-34.3-16.6-3.6-1.6-8.3-3.6-10.4-4.4-35.3-15.3-94.5-29.8-139.7-34.3-7.4-0.7-17.2-1.8-21.7-2.2-20.4-2.3-48.7-2.6-209.4-2.6-135.8 0-169.9 0.3-169.4 1zm330.7 43.3c33.8 2 54.6 4.6 78.9 10.5 74.2 17.6 126.4 54.8 164.3 117 3.5 5.8 18.3 36 20.5 42.1 10.5 28.3 15.6 45.1 20.1 67.3 1.1 5.4 2.6 12.6 3.3 16 0.7 3.3 1 6.4 0.7 6.7-0.5 0.4-100.9 0.6-223.3 0.5l-222.5-0.2-0.3-128.5c-0.1-70.6 0-129.3 0.3-130.4l0.4-1.9h71.1c39 0 78 0.4 86.5 0.9zm297.5 350.3c0.7 4.3 0.7 77.3 0 80.9l-0.6 2.7-227.5-0.2-227.4-0.3-0.2-42.4c-0.2-23.3 0-42.7 0.2-43.1 0.3-0.5 97.2-0.8 227.7-0.8h227.2zm-10.2 171.7c0.5 1.5-1.9 13.8-6.8 33.8-5.6 22.5-13.2 45.2-20.9 62-3.8 8.6-13.3 27.2-15.6 30.7-1.1 1.6-4.3 6.7-7.1 11.2-18 28.2-43.7 53.9-73 72.9-10.7 6.8-32.7 18.4-38.6 20.2-1.2 0.3-2.5 0.9-3 1.3-0.7 0.6-9.8 4-20.4 7.8-19.5 6.9-56.6 14.4-86.4 17.5-19.3 1.9-22.4 2-96.7 2h-76.9v-129.7-129.8l220.9-0.4c121.5-0.2 221.6-0.5 222.4-0.7 0.9-0.1 1.8 0.5 2.1 1.2z'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-size: contain;
            background-position: center;
            vertical-align: middle;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="<?php echo e(asset('admin-assets/js/warehouse-reports.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            // Initialize Select2 for filter dropdowns
            $('.warehouse-select2').select2({
                theme: 'bootstrap-5',
                allowClear: true,
                placeholder: function() {
                    return $(this).data('placeholder') || 'Select...';
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/reports/returns.blade.php ENDPATH**/ ?>