<?php $__env->startSection('title', 'User Management'); ?>
<?php $__env->startSection('page-title', 'User Management'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item active" aria-current="page">Users</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-actions'); ?>
    <?php if(auth()->user()->hasPermission('create_users')): ?>
    <div class="ml-auto">
        <button class="btn btn-primary" data-toggle="modal" data-target="#createUserModal">
            <i class="material-icons">add</i> Add User
        </button>
    </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Filters -->
    <div class="card mb-3">
        <div class="card-body">
            <form method="GET" class="row align-items-end">
                <div class="col-md-3">
                    <label for="search" class="form-label">Search</label>
                    <input type="text" class="form-control" id="search" name="search" value="<?php echo e(request('search')); ?>" placeholder="Name, email, employee ID...">
                </div>
                <div class="col-md-2">
                    <label for="role" class="form-label">Role</label>
                    <select class="form-control" id="role" name="role">
                        <option value="">All Roles</option>
                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($role->name); ?>" <?php echo e(request('role') == $role->name ? 'selected' : ''); ?>>
                                <?php echo e($role->display_name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="status" class="form-label">Status</label>
                    <select class="form-control" id="status" name="status">
                        <option value="">All Status</option>
                        <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>Active</option>
                        <option value="inactive" <?php echo e(request('status') == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                        <option value="suspended" <?php echo e(request('status') == 'suspended' ? 'selected' : ''); ?>>Suspended</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="department" class="form-label">Department</label>
                    <select class="form-control" id="department" name="department">
                        <option value="">All Departments</option>
                        <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dept): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($dept); ?>" <?php echo e(request('department') == $dept ? 'selected' : ''); ?>><?php echo e($dept); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-outline-primary">
                        <i class="material-icons">search</i> Search
                    </button>
                    <a href="<?php echo e(route('admin.users')); ?>" class="btn btn-outline-secondary">
                        <i class="material-icons">clear</i> Clear
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Users Table -->
    <div class="card">
        <div class="card-header card-header-large bg-white d-flex align-items-center">
            <div class="flex">
                <h4 class="card-header__title">Users</h4>
                <div class="card-subtitle text-muted">Manage system users and their roles</div>
            </div>
            <div class="ml-auto">
                <span class="badge badge-light"><?php echo e($users->total()); ?> total users</span>
            </div>
        </div>
        <div class="table-responsive">
            <table class="table mb-0">
                <thead>
                    <tr>
                        <th>User</th>
                        <th>Role</th>
                        <th>Department</th>
                        <th>Status</th>
                        <th>Last Login</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <div class="media align-items-center">
                                <div class="avatar avatar-sm mr-3">
                                    <img src="<?php echo e($user->avatar_url); ?>" alt="<?php echo e($user->full_name); ?>" class="avatar-img rounded-circle">
                                </div>
                                <div class="media-body">
                                    <strong><?php echo e($user->full_name); ?></strong>
                                    <div class="text-muted small"><?php echo e($user->email); ?></div>
                                    <?php if($user->employee_id): ?>
                                        <div class="text-muted small">ID: <?php echo e($user->employee_id); ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </td>
                        <td>
                            <?php if($user->role): ?>
                                <span class="badge badge-soft-info"><?php echo e($user->role->display_name); ?></span>
                            <?php else: ?>
                                <span class="badge badge-soft-secondary">No Role</span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($user->department ?? 'N/A'); ?></td>
                        <td>
                            <?php
                                $statusClass = match($user->status) {
                                    'active' => 'badge-soft-success',
                                    'inactive' => 'badge-soft-warning',
                                    'suspended' => 'badge-soft-danger',
                                    default => 'badge-soft-secondary'
                                };
                            ?>
                            <span class="badge <?php echo e($statusClass); ?>"><?php echo e(ucfirst($user->status)); ?></span>
                            <?php if($user->first_login): ?>
                                <span class="badge badge-soft-info badge-sm">First Login</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($user->last_login_at): ?>
                                <span class="text-muted small"><?php echo e($user->last_login_at->format('M d, Y H:i')); ?></span>
                            <?php else: ?>
                                <span class="text-muted small">Never</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="dropdown">
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown" data-caret="false">
                                    <i class="material-icons">more_vert</i>
                                </a>
                                <div class="dropdown-menu dropdown-menu-right">
                                    <a href="#" class="dropdown-item" data-toggle="modal" data-target="#viewUserModal<?php echo e($user->id); ?>">
                                        <i class="material-icons mr-2">visibility</i> View Details
                                    </a>
                                    <?php if(auth()->user()->hasPermission('edit_users')): ?>
                                        <a href="#" class="dropdown-item" data-toggle="modal" data-target="#editUserModal<?php echo e($user->id); ?>">
                                            <i class="material-icons mr-2">edit</i> Edit User
                                        </a>
                                        <a href="#" class="dropdown-item text-warning" onclick="resetPassword(<?php echo e($user->id); ?>)">
                                            <i class="material-icons mr-2">vpn_key</i> Reset Password
                                        </a>
                                    <?php endif; ?>
                                    <?php if(auth()->user()->hasPermission('delete_users') && $user->id !== auth()->id()): ?>
                                        <div class="dropdown-divider"></div>
                                        <a href="#" class="dropdown-item text-danger" data-toggle="modal" data-target="#deleteUserModal<?php echo e($user->id); ?>">
                                            <i class="material-icons mr-2">delete</i> Delete User
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="text-center py-4">
                            <div class="empty-state">
                                <i class="material-icons mb-3" style="font-size: 48px; color: #ddd;">people_outline</i>
                                <h5 class="text-muted">No users found</h5>
                                <p class="text-muted">
                                    <?php if(request()->hasAny(['search', 'role', 'status', 'department'])): ?>
                                        Try adjusting your search criteria or <a href="<?php echo e(route('admin.users')); ?>">clear filters</a>.
                                    <?php else: ?>
                                        Users will appear here when they are created.
                                    <?php endif; ?>
                                </p>
                                <?php if(auth()->user()->hasPermission('create_users')): ?>
                                    <button class="btn btn-primary" data-toggle="modal" data-target="#createUserModal">
                                        <i class="material-icons">add</i> Add First User
                                    </button>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php if($users->hasPages()): ?>
            <div class="card-footer">
                <?php echo e($users->appends(request()->query())->links('pagination::flowdash')); ?>

            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modals'); ?>
    <?php if(auth()->user()->hasPermission('create_users')): ?>
        <?php echo $__env->make('admin.users.modals.create', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php endif; ?>
    
    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php echo $__env->make('admin.users.modals.view', ['user' => $user], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        
        <?php if(auth()->user()->hasPermission('edit_users')): ?>
            <?php echo $__env->make('admin.users.modals.edit', ['user' => $user], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php endif; ?>
        
        <?php if(auth()->user()->hasPermission('delete_users') && $user->id !== auth()->id()): ?>
            <?php echo $__env->make('admin.users.modals.delete', ['user' => $user], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function resetPassword(userId) {
    if (confirm('Are you sure you want to reset this user\'s password?')) {
        fetch(`/admin/users/${userId}/reset-password`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json',
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert(`Password reset successfully!\nTemporary password: ${data.temp_password}\n\nPlease provide this to the user securely.`);
            } else {
                alert('Error: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while resetting the password.');
        });
    }
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/kcg/public_html/wms.kcguae.com/resources/views/admin/users/index.blade.php ENDPATH**/ ?>