@extends('layouts.admin-simple')

@section('title', 'Edit Project')
@section('page-title', 'Edit Project')
@section('page-subtitle', 'Update project information')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('warehouse.projects.index') }}">Projects</a></li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.projects.show', $project) }}">{{ $project->project_name }}</a></li>
    <li class="breadcrumb-item active">Edit</li>
@endsection

@section('content')
<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex justify-content-between align-items-center">
        <h6 class="m-0 font-weight-bold text-primary">Edit Project Information</h6>
        <span class="text-muted">{{ $project->project_number }}</span>
    </div>

    <div class="card-body">
        <form action="{{ route('warehouse.projects.update', $project) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="project_number" class="form-label">Project Number</label>
                        <input type="text" name="project_number" id="project_number"
                               class="form-control @error('project_number') is-invalid @enderror"
                               value="{{ old('project_number', $project->project_number) }}"
                               placeholder="Enter project number">
                        @error('project_number')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="project_name" class="form-label">Project Name <span class="text-danger">*</span></label>
                        <input type="text" name="project_name" id="project_name"
                               class="form-control @error('project_name') is-invalid @enderror"
                               value="{{ old('project_name', $project->project_name) }}"
                               placeholder="Enter project name" required>
                        @error('project_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label for="project_division_id" class="form-label">Project Division <span class="text-danger">*</span></label>
                        <select name="project_division_id" id="project_division_id"
                                class="form-control @error('project_division_id') is-invalid @enderror" required>
                            <option value="">Select a division</option>
                            @foreach($divisions as $division)
                                <option value="{{ $division->id }}" {{ old('project_division_id', $project->project_division_id) == $division->id ? 'selected' : '' }}>
                                    {{ $division->division_name }} ({{ $division->division_code }})
                                </option>
                            @endforeach
                        </select>
                        @error('project_division_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="d-flex justify-content-between mt-4 pt-3 border-top">
                <a href="{{ route('warehouse.projects.show', $project) }}" class="btn btn-secondary">
                    <i class="material-icons mr-1" style="font-size: 16px;">cancel</i>
                    Cancel
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="material-icons mr-1" style="font-size: 16px;">save</i>
                    Update Project
                </button>
            </div>
        </form>
    </div>
</div>
@endsection