@extends('layouts.admin-simple')

@section('title', 'Edit Item')
@section('page-title', 'Edit Item')
@section('page-subtitle', 'Update item information')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('warehouse.items.index') }}">Items</a></li>
    <li class="breadcrumb-item active">Edit</li>
@endsection

@section('content')
<div class="card shadow mb-4">
                <div class="card-header py-3 d-flex justify-content-between align-items-center">
                    <h6 class="m-0 font-weight-bold text-primary">Edit Item Information</h6>
                    <span class="text-muted">{{ $item->item_code }}</span>
                </div>

                <div class="card-body">
                    <form action="{{ route('warehouse.items.update', $item->id) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <!-- Basic Information -->
                        <div class="mb-4">
                            <h6 class="text-primary font-weight-bold mb-3">Basic Information</h6>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="item_code" class="form-label">Item Code</label>
                                    <input type="text" name="item_code" id="item_code"
                                           class="form-control @error('item_code') is-invalid @enderror"
                                           value="{{ old('item_code', $item->item_code) }}">
                                    @error('item_code')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <x-warehouse.select2-dropdown
                                    name="category_id"
                                    id="category_id"
                                    label="Category"
                                    placeholder="Select Category"
                                    :options="collect($categories)->map(fn($cat) => ['value' => $cat->id, 'text' => $cat->category_name])->prepend(['value' => '', 'text' => 'Select Category'])->toArray()"
                                    :selected="old('category_id', $item->category_id)"
                                    required="true"
                                />
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="item_description" class="form-label">Item Description <span class="text-danger">*</span></label>
                                    <input type="text" name="item_description" id="item_description"
                                           class="form-control @error('item_description') is-invalid @enderror"
                                           value="{{ old('item_description', $item->item_description) }}" required>
                                    @error('item_description')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <x-warehouse.select2-dropdown
                                    name="unit_id"
                                    id="unit_id"
                                    label="Unit of Measure"
                                    placeholder="Select Unit"
                                    :options="$units"
                                    :selected="old('unit_id', $item->unit_id)"
                                    required="true"
                                />
                            </div>
                            <div class="col-md-6">
                                <x-warehouse.select2-dropdown
                                    name="status"
                                    id="status"
                                    label="Status"
                                    placeholder="Select Status"
                                    :options="[
                                        ['value' => 'active', 'text' => 'Active'],
                                        ['value' => 'inactive', 'text' => 'Inactive'],
                                        ['value' => 'discontinued', 'text' => 'Discontinued']
                                    ]"
                                    :selected="old('status', $item->status)"
                                    required="true"
                                />
                            </div>
                        </div>

                        <!-- Stock Level Information -->
                        <div class="mb-4 mt-4">
                            <h6 class="text-primary font-weight-bold mb-3">Stock Level Information</h6>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="min_stock_level" class="form-label">Min Stock Level</label>
                                    <input type="number" name="min_stock_level" id="min_stock_level"
                                           class="form-control @error('min_stock_level') is-invalid @enderror"
                                           value="{{ old('min_stock_level', $item->min_stock_level) }}"
                                           min="0" step="0.01">
                                    @error('min_stock_level')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="max_stock_level" class="form-label">Max Stock Level</label>
                                    <input type="number" name="max_stock_level" id="max_stock_level"
                                           class="form-control @error('max_stock_level') is-invalid @enderror"
                                           value="{{ old('max_stock_level', $item->max_stock_level) }}"
                                           min="0" step="0.01">
                                    @error('max_stock_level')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="reorder_point" class="form-label">Reorder Point</label>
                                    <input type="number" name="reorder_point" id="reorder_point"
                                           class="form-control @error('reorder_point') is-invalid @enderror"
                                           value="{{ old('reorder_point', $item->reorder_point) }}"
                                           min="0" step="0.01">
                                    @error('reorder_point')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Additional Information -->
                        <div class="mb-4 mt-4">
                            <h6 class="text-primary font-weight-bold mb-3">Additional Information</h6>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes" class="form-label">Notes</label>
                                    <textarea name="notes" id="notes" rows="3"
                                              class="form-control @error('notes') is-invalid @enderror"
                                              placeholder="Optional notes about this item">{{ old('notes', $item->notes) }}</textarea>
                                    @error('notes')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-between mt-4 pt-3 border-top">
                            <a href="{{ route('warehouse.items.index') }}" class="btn btn-secondary">
                                <i class="material-icons mr-1" style="font-size: 16px;">cancel</i>
                                Cancel
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="material-icons mr-1" style="font-size: 16px;">save</i>
                                Update Item
                            </button>
                        </div>
                    </form>
                </div>
            </div>
@endsection