@extends('layouts.admin-simple')

@section('title', 'Incoming Operations')

@section('breadcrumb')
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item active">Incoming Operations</li>
@endsection

@section('page-title')
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Incoming Operations</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Enhanced construction materials receiving system</p>
        </div>
        @can('warehouse.incoming.create')
        <div class="page-actions-right d-flex align-items-center">
            <a href="{{ route('warehouse.incoming-operations.create', ['type' => 'supplier_delivery']) }}" class="btn btn-sm btn-primary" title="Create new incoming operation">
                <i class="material-icons mr-1" style="font-size: 16px;">add</i>
                New Operation
            </a>
        </div>
        @endcan
    </div>
@endsection

@section('content')
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <!-- Statistics Cards -->
    <div class="row mb-4 warehouse-stats-row">
        <div class="col-xl-3 col-md-6 mb-3">
            <x-warehouse.stats-card
                title="Total Operations"
                :value="$operations->total() ?? 0"
                icon="input"
                color="primary"
                subtitle="All incoming operations"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <x-warehouse.stats-card
                title="Direct Processing"
                :value="$statistics['direct_processing'] ?? 0"
                icon="flash_on"
                color="warning"
                subtitle="Auto-processed operations"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <x-warehouse.stats-card
                title="Pending Review"
                :value="$statistics['pending_review'] ?? 0"
                icon="check_circle"
                color="success"
                subtitle="Needs manual approval"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <x-warehouse.stats-card
                title="Completed"
                :value="$statistics['completed'] ?? 0"
                icon="done_all"
                color="info"
                subtitle="Inventory updated"
            />
        </div>
    </div>

    <!-- Filters Panel -->
    <div class="card mb-4 warehouse-filters-panel">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="material-icons align-middle mr-2">filter_list</i>
                Filters
            </h5>
        </div>
        <div class="card-body">
            <form id="filterForm" class="warehouse-filter-form" method="GET" action="{{ route('warehouse.incoming-operations.index') }}">
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Search</label>
                        <input type="text" name="search" value="{{ request('search') }}" class="form-control"
                               placeholder="Operation #, Supplier">
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Type</label>
                        <select name="type" class="form-control warehouse-select2">
                            <option value="">All Types</option>
                            <option value="supplier_delivery" {{ request('type') == 'supplier_delivery' ? 'selected' : '' }}>Supplier Delivery</option>
                            <option value="site_return" {{ request('type') == 'site_return' ? 'selected' : '' }}>Site Return</option>
                            <option value="transfer_in" {{ request('type') == 'transfer_in' ? 'selected' : '' }}>Transfer In</option>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-control warehouse-select2">
                            <option value="">All Statuses</option>
                            <option value="pending_inspection" {{ request('status') == 'pending_inspection' ? 'selected' : '' }}>Pending Inspection</option>
                            <option value="approved" {{ request('status') == 'approved' ? 'selected' : '' }}>Approved</option>
                            <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Completed</option>
                            <option value="rejected" {{ request('status') == 'rejected' ? 'selected' : '' }}>Rejected</option>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Date From</label>
                        <input type="date" name="date_from" value="{{ request('date_from') }}" class="form-control">
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Date To</label>
                        <input type="date" name="date_to" value="{{ request('date_to') }}" class="form-control">
                    </div>

                    <div class="col-md-1 mb-3">
                        <label class="form-label">&nbsp;</label>
                        <button type="submit" class="btn btn-primary btn-block">
                            <i class="material-icons" style="font-size: 18px; vertical-align: middle;">search</i>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Operations Table -->
    <div class="card">
        <div class="card-header warehouse-report-header">
            <h5 class="mb-0 warehouse-report-title">
                <i class="material-icons align-middle mr-2">list</i>
                Operations List ({{ $operations->total() }} total operations)
            </h5>
        </div>
        <div class="card-body p-0">
            <div class="warehouse-table-container">
                <!-- Loading Overlay -->
                <div class="warehouse-loading-overlay" id="tableLoadingOverlay">
                    <div class="warehouse-loading-content">
                        <div class="text-center">
                            <div class="spinner-border text-primary" role="status">
                                <span class="sr-only">Loading...</span>
                            </div>
                            <div class="mt-2">Loading operations data...</div>
                        </div>
                    </div>
                </div>

                <!-- Table -->
                <div class="warehouse-table-wrapper">
                    <table class="table table-hover mb-0 warehouse-table">
                        <thead class="thead-light">
                            <tr>
                                <th style="min-width: 150px;">Operation #</th>
                                <th style="min-width: 130px;">Type</th>
                                <th style="min-width: 120px;">Date</th>
                                <th style="min-width: 180px;">Supplier/Source</th>
                                <th style="min-width: 100px;" class="text-center">Status</th>
                                <th style="min-width: 120px;" class="text-right">Total (AED)</th>
                                <th style="min-width: 80px;" class="text-center">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($operations as $operation)
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="operation-icon mr-3">
                                                <i class="material-icons text-primary" style="font-size: 24px;">input</i>
                                            </div>
                                            <div>
                                                <div class="font-weight-medium">{{ $operation->operation_number }}</div>
                                                <small class="text-muted">ID: {{ $operation->id }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        @php
                                            $typeColors = [
                                                'supplier_delivery' => 'primary',
                                                'site_return' => 'warning',
                                                'transfer_in' => 'info'
                                            ];
                                            $typeColor = $typeColors[$operation->operation_type] ?? 'secondary';
                                        @endphp
                                        <span class="badge warehouse-badge warehouse-status-{{ $typeColor }}">
                                            {{ ucfirst(str_replace('_', ' ', $operation->operation_type)) }}
                                        </span>
                                    </td>
                                    <td class="warehouse-cell-date">
                                        {{ \Carbon\Carbon::parse($operation->operation_date)->format('d M Y') }}
                                    </td>
                                    <td>
                                        <div>
                                            @if($operation->supplier)
                                                <div class="font-weight-medium">{{ $operation->supplier->name }}</div>
                                                @if($operation->supplier->supplier_code)
                                                    <small class="text-muted">Code: {{ $operation->supplier->supplier_code }}</small>
                                                @endif
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </div>
                                    </td>
                                    <td class="warehouse-cell-status">
                                        @php
                                            $statusColors = [
                                                'completed' => 'success',
                                                'pending_inspection' => 'warning',
                                                'approved' => 'info',
                                                'rejected' => 'danger'
                                            ];
                                            $statusColor = $statusColors[$operation->status] ?? 'secondary';
                                        @endphp
                                        <span class="badge warehouse-badge warehouse-status-{{ $statusColor }}">
                                            {{ ucfirst(str_replace('_', ' ', $operation->status)) }}
                                        </span>
                                    </td>
                                    <td class="text-right">
                                        <span class="font-weight-medium">{{ number_format($operation->total_amount_aed ?? 0, 2) }}</span>
                                    </td>
                                    <td class="text-center">
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('warehouse.incoming-operations.show', $operation->id) }}"
                                               class="btn btn-sm btn-outline-primary warehouse-action-btn" title="View Details">
                                                <i class="material-icons">visibility</i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="warehouse-empty-state">
                                        <i class="material-icons">inbox</i>
                                        <h5>No Operations Found</h5>
                                        <p class="text-muted">There are no incoming operations to display.</p>
                                        @can('warehouse.incoming.create')
                                            <a href="{{ route('warehouse.incoming-operations.create', ['type' => 'supplier_delivery']) }}" class="btn btn-primary">
                                                <i class="material-icons mr-1">add</i>
                                                Create First Operation
                                            </a>
                                        @endcan
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        @if($operations->hasPages())
            <div class="card-footer">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        Showing {{ $operations->firstItem() }} to {{ $operations->lastItem() }}
                        of {{ $operations->total() }} operations
                    </div>
                    <div>
                        <nav class="warehouse-pagination">
                            {{ $operations->links('pagination::bootstrap-4') }}
                        </nav>
                    </div>
                </div>
            </div>
        @endif
    </div>
@endsection

@push('styles')
    <link href="{{ asset('admin-assets/css/warehouse-reports.css') }}" rel="stylesheet" />
    <style>
        .operation-icon {
            width: 40px;
            height: 40px;
            background: #f8f9fa;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            border: 2px solid #e9ecef;
        }
    </style>
@endpush

@push('scripts')
    <script src="{{ asset('admin-assets/js/warehouse-reports.js') }}"></script>
    <script>
        $(document).ready(function() {
            console.log('Incoming Operations page loaded successfully');

            // Hide preloader if it's still showing
            const preloader = document.querySelector('.preloader');
            if (preloader) {
                setTimeout(() => {
                    preloader.style.display = 'none';
                }, 500);
            }
        });

        // Enhanced alert function
        function showAlert(type, message) {
            const alertHtml = `
                <div class="alert alert-${type} alert-dismissible fade show" role="alert">
                    ${message}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            `;
            $('.container-fluid.page__container').prepend(alertHtml);

            // Auto-dismiss after 5 seconds
            setTimeout(() => {
                $('.alert').alert('close');
            }, 5000);
        }
    </script>
@endpush
