<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Admin Panel') - {{ config('app.name') }}</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Material Icons -->
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">

    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">

    <!-- Custom Styles -->
    <style>
        * { font-family: 'Poppins', sans-serif !important; }
        body { background-color: #f4f6f9 !important; }
        .sidebar { background-color: #ffffff; min-height: 100vh; }
        .navbar { background-color: #ffffff !important; border-bottom: 1px solid #e3e6f0; }
        .main-content { margin-left: 250px; padding: 20px; }
        @media (max-width: 768px) {
            .main-content { margin-left: 0; }
            .sidebar { display: none; }
        }
    </style>

    @stack('styles')
</head>

<body>
    <!-- Sidebar -->
    <div class="sidebar position-fixed" style="width: 250px; height: 100vh; left: 0; top: 0; overflow-y: auto;">
        <div class="p-3">
            <h5>KCG -WMS</h5>
            <hr>
            <ul class="list-unstyled">
                <li><a href="{{ route('admin.dashboard') }}" class="d-block p-2 text-decoration-none">Dashboard</a></li>
                <li><a href="#" class="d-block p-2 text-decoration-none">Warehouse</a></li>
                <li><a href="#" class="d-block p-2 text-decoration-none">Suppliers</a></li>
                <li><a href="#" class="d-block p-2 text-decoration-none">Projects</a></li>
                <li><a href="#" class="d-block p-2 text-decoration-none">Items</a></li>
            </ul>
        </div>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Header -->
        <nav class="navbar navbar-expand-lg navbar-light">
            <div class="container-fluid">
                <h1 class="navbar-brand mb-0">@yield('title', 'Admin Panel')</h1>
                <div class="navbar-nav ml-auto">
                    <div class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown">
                            KCG Administrator
                        </a>
                        <div class="dropdown-menu">
                            <a class="dropdown-item" href="#">Profile</a>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item" href="{{ route('admin.logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">Logout</a>
                            <form id="logout-form" action="{{ route('admin.logout') }}" method="POST" style="display: none;">
                                @csrf
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Breadcrumb -->
        @if(View::hasSection('breadcrumb'))
        <nav aria-label="breadcrumb" class="mt-3">
            <ol class="breadcrumb">
                @yield('breadcrumb')
            </ol>
        </nav>
        @endif

        <!-- Page Title -->
        @yield('page-title')

        <!-- Content -->
        <div class="content mt-4">
            <!-- Success Message -->
            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="close" data-dismiss="alert">
                        <span>&times;</span>
                    </button>
                </div>
            @endif

            <!-- Error Message -->
            @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="close" data-dismiss="alert">
                        <span>&times;</span>
                    </button>
                </div>
            @endif

            @yield('content')
        </div>
    </div>

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Bootstrap -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.bundle.min.js"></script>

    @stack('scripts')
</body>
</html>