// Sticky Header Functionality
document.addEventListener('DOMContentLoaded', function() {
    const header = document.querySelector('.site-header');
    const body = document.body;
    
    if (!header) return;
    
    let lastScrollTop = 0;
    let isScrolling = false;
    let ticking = false;
    
    // Throttle scroll events for better performance
    function requestTick() {
        if (!ticking) {
            requestAnimationFrame(updateHeader);
            ticking = true;
        }
    }
    
    function updateHeader() {
        const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
        const scrollDirection = scrollTop > lastScrollTop ? 'down' : 'up';
        const scrollDistance = Math.abs(scrollTop - lastScrollTop);
        
        // Only process significant scroll changes
        if (scrollDistance > 5) {
            // Add scrolled class for background effect
            if (scrollTop > 50) {
                header.classList.add('sticky-header-scrolled');
            } else {
                header.classList.remove('sticky-header-scrolled');
            }
            
            // Hide/Show header based on scroll direction
            if (scrollTop > 150) { // Start hiding after 150px scroll
                if (scrollDirection === 'down' && scrollDistance > 10) {
                    // Scrolling down - hide header
                    header.classList.add('sticky-header-hidden');
                    header.classList.remove('sticky-header-visible');
                } else if (scrollDirection === 'up' && scrollDistance > 10) {
                    // Scrolling up - show header
                    header.classList.remove('sticky-header-hidden');
                    header.classList.add('sticky-header-visible');
                }
            } else {
                // Near top - always show header
                header.classList.remove('sticky-header-hidden');
                header.classList.add('sticky-header-visible');
            }
            
            lastScrollTop = scrollTop;
        }
        
        ticking = false;
    }
    
    // Handle scroll events
    window.addEventListener('scroll', requestTick, { passive: true });
    
    // Handle window resize
    window.addEventListener('resize', function() {
        // Recalculate header height if needed
        const headerHeight = header.offsetHeight;
        body.style.paddingTop = headerHeight + 'px';
    });
    
    // Initialize header state
    header.classList.add('sticky-header-visible');
    
    // Set initial body padding based on actual header height
    const headerHeight = header.offsetHeight;
    body.style.paddingTop = headerHeight + 'px';
});