<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\VideoSetting;

class VideoSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $videoSettings = [
            [
                'key' => 'hero_video',
                'title' => 'Hero Section Video',
                'description' => 'Background video for the hero section on the homepage',
                'video_type' => 'youtube',
                'video_url' => 'https://www.youtube.com/watch?v=MNzWVa9q9xE',
                'settings' => [
                    'autoplay' => 1,
                    'mute' => 1,
                    'loop' => 1,
                    'controls' => 0,
                    'showinfo' => 0,
                    'rel' => 0,
                    'modestbranding' => 1,
                    'iv_load_policy' => 3,
                    'disablekb' => 1,
                    'enablejsapi' => 1,
                    'start' => 0,
                    'vq' => 'hd720'
                ],
                'is_enabled' => true,
                'preload_at' => now()
            ],
            [
                'key' => 'who_we_are_video',
                'title' => 'Who We Are Section Video',
                'description' => 'Video for the "Who We Are" section on the homepage',
                'video_type' => 'youtube',
                'video_url' => 'https://www.youtube.com/watch?v=MNzWVa9q9xE',
                'settings' => [
                    'autoplay' => 1,
                    'mute' => 0,
                    'loop' => 0,
                    'controls' => 1,
                    'showinfo' => 0,
                    'rel' => 0,
                    'modestbranding' => 1,
                    'iv_load_policy' => 3,
                    'enablejsapi' => 1
                ],
                'is_enabled' => true,
                'preload_at' => now()
            ],
            [
                'key' => 'about_video',
                'title' => 'About Page Video',
                'description' => 'Main video displayed on the About Us page',
                'video_type' => 'youtube',
                'video_url' => 'https://www.youtube.com/watch?v=MNzWVa9q9xE',
                'settings' => [
                    'autoplay' => 1,
                    'mute' => 0,
                    'loop' => 0,
                    'controls' => 1,
                    'showinfo' => 0,
                    'rel' => 0,
                    'modestbranding' => 1,
                    'iv_load_policy' => 3,
                    'enablejsapi' => 1
                ],
                'is_enabled' => true,
                'preload_at' => now()
            ]
        ];

        foreach ($videoSettings as $settingData) {
            VideoSetting::updateOrCreate(
                ['key' => $settingData['key']],
                $settingData
            );
        }
    }
}
