<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ProjectDivisionSeeder extends Seeder
{
    public function run(): void
    {
        $divisions = [
            [
                'division_name' => 'Residential Construction',
                'division_code' => 'RC',
                'description' => 'Single-family homes, apartments, and residential complexes',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'division_name' => 'Commercial Construction',
                'division_code' => 'CC',
                'description' => 'Office buildings, retail spaces, and commercial facilities',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'division_name' => 'Infrastructure',
                'division_code' => 'INF',
                'description' => 'Roads, bridges, utilities, and public infrastructure',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'division_name' => 'Industrial Projects',
                'division_code' => 'IND',
                'description' => 'Factories, warehouses, and industrial facilities',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'division_name' => 'Healthcare Facilities',
                'division_code' => 'HC',
                'description' => 'Hospitals, clinics, and medical facilities',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'division_name' => 'Educational Facilities',
                'division_code' => 'EDU',
                'description' => 'Schools, universities, and educational buildings',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'division_name' => 'Renovation & Remodeling',
                'division_code' => 'RR',
                'description' => 'Building renovations, refurbishments, and remodeling projects',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'division_name' => 'Civil Engineering',
                'division_code' => 'CE',
                'description' => 'Site preparation, earthwork, and civil engineering projects',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        DB::table('project_divisions')->insert($divisions);
    }
}