<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\ProductCategory;
use App\Models\ProductStandard;
use App\Models\ProductApplication;
use App\Models\Product;
use App\Models\ProductSpecification;

class ProductHierarchySeeder extends Seeder
{
    public function run(): void
    {
        // Create Product Categories
        $floatGlass = ProductCategory::create([
            'name' => 'Float Glass',
            'slug' => 'float-glass',
            'description' => 'High-quality float glass products for various applications',
            'sort_order' => 1,
            'is_active' => true
        ]);

        $patternGlass = ProductCategory::create([
            'name' => 'Pattern Glass',
            'slug' => 'pattern-glass',
            'description' => 'Decorative patterned glass with unique textures and designs',
            'sort_order' => 2,
            'is_active' => true
        ]);

        $mirrorGlass = ProductCategory::create([
            'name' => 'Mirror Glass',
            'slug' => 'mirror-glass',
            'description' => 'Premium mirror glass for reflective applications',
            'sort_order' => 3,
            'is_active' => true
        ]);

        // Create Standards for Float Glass
        $floatJIS = ProductStandard::create([
            'category_id' => $floatGlass->id,
            'name' => 'JIS',
            'code' => 'JIS R 3202',
            'description' => 'Japanese Industrial Standard for float glass',
            'sort_order' => 1,
            'is_active' => true
        ]);

        $floatEN = ProductStandard::create([
            'category_id' => $floatGlass->id,
            'name' => 'EN',
            'code' => 'EN 572-2',
            'description' => 'European Standard for float glass',
            'sort_order' => 2,
            'is_active' => true
        ]);

        $floatASTM = ProductStandard::create([
            'category_id' => $floatGlass->id,
            'name' => 'ASTM',
            'code' => 'ASTM C1036',
            'description' => 'American Standard for flat glass',
            'sort_order' => 3,
            'is_active' => true
        ]);

        // Create Standards for Pattern Glass
        $patternJIS = ProductStandard::create([
            'category_id' => $patternGlass->id,
            'name' => 'JIS',
            'code' => 'JIS R 3206',
            'description' => 'Japanese Industrial Standard for pattern glass',
            'sort_order' => 1,
            'is_active' => true
        ]);

        // Create Standards for Mirror Glass
        $mirrorSASO = ProductStandard::create([
            'category_id' => $mirrorGlass->id,
            'name' => 'SASO',
            'code' => 'SASO 2663',
            'description' => 'Saudi Arabian Standard for mirror glass',
            'sort_order' => 1,
            'is_active' => true
        ]);

        // Create Applications for Float Glass JIS
        $floatJISArch = ProductApplication::create([
            'standard_id' => $floatJIS->id,
            'name' => 'Architecture',
            'description' => 'Architectural applications for buildings and construction',
            'sort_order' => 1,
            'is_active' => true
        ]);

        $floatJISAuto = ProductApplication::create([
            'standard_id' => $floatJIS->id,
            'name' => 'Automotive',
            'description' => 'Automotive glass applications',
            'sort_order' => 2,
            'is_active' => true
        ]);

        // Create Applications for Float Glass EN
        $floatENArch = ProductApplication::create([
            'standard_id' => $floatEN->id,
            'name' => 'Architecture',
            'description' => 'European standard architectural glass',
            'sort_order' => 1,
            'is_active' => true
        ]);

        // Create Applications for Pattern Glass
        $patternDecorative = ProductApplication::create([
            'standard_id' => $patternJIS->id,
            'name' => 'Decorative',
            'description' => 'Decorative applications for interior design',
            'sort_order' => 1,
            'is_active' => true
        ]);

        // Create Sample Products
        $clearFloat = Product::create([
            'application_id' => $floatJISArch->id,
            'name' => 'Clear Float Glass',
            'slug' => 'clear-float-glass',
            'description' => 'Premium clear float glass for architectural applications',
            'features' => 'High transparency, smooth surface, excellent optical quality',
            'thickness_min' => 3.0,
            'thickness_max' => 19.0,
            'thickness_unit' => 'mm',
            'sort_order' => 1,
            'is_featured' => true,
            'is_active' => true
        ]);

        $tintedFloat = Product::create([
            'application_id' => $floatJISArch->id,
            'name' => 'Tinted Float Glass',
            'slug' => 'tinted-float-glass',
            'description' => 'Energy-efficient tinted float glass',
            'features' => 'Solar control, reduced glare, available in multiple colors',
            'thickness_min' => 4.0,
            'thickness_max' => 12.0,
            'thickness_unit' => 'mm',
            'sort_order' => 2,
            'is_featured' => false,
            'is_active' => true
        ]);

        $autoGlass = Product::create([
            'application_id' => $floatJISAuto->id,
            'name' => 'Automotive Float Glass',
            'slug' => 'automotive-float-glass',
            'description' => 'High-quality automotive grade float glass',
            'features' => 'Safety compliant, optical clarity, precise thickness',
            'thickness_min' => 3.0,
            'thickness_max' => 6.0,
            'thickness_unit' => 'mm',
            'sort_order' => 1,
            'is_featured' => true,
            'is_active' => true
        ]);

        $ripplePattern = Product::create([
            'application_id' => $patternDecorative->id,
            'name' => 'Ripple Pattern Glass',
            'slug' => 'ripple-pattern-glass',
            'description' => 'Elegant ripple pattern for decorative applications',
            'features' => 'Unique texture, privacy control, light diffusion',
            'thickness_min' => 4.0,
            'thickness_max' => 8.0,
            'thickness_unit' => 'mm',
            'sort_order' => 1,
            'is_featured' => true,
            'is_active' => true
        ]);

        // Create Product Specifications
        ProductSpecification::create([
            'product_id' => $clearFloat->id,
            'spec_type' => 'size',
            'name' => 'Maximum Size',
            'value' => '3300 x 2140',
            'unit' => 'mm',
            'sort_order' => 1
        ]);

        ProductSpecification::create([
            'product_id' => $clearFloat->id,
            'spec_type' => 'technical',
            'name' => 'Light Transmission',
            'value' => '90',
            'unit' => '%',
            'sort_order' => 2
        ]);

        ProductSpecification::create([
            'product_id' => $clearFloat->id,
            'spec_type' => 'technical',
            'name' => 'Density',
            'value' => '2500',
            'unit' => 'kg/m³',
            'sort_order' => 3
        ]);

        ProductSpecification::create([
            'product_id' => $tintedFloat->id,
            'spec_type' => 'size',
            'name' => 'Standard Size',
            'value' => '3210 x 2140',
            'unit' => 'mm',
            'sort_order' => 1
        ]);

        ProductSpecification::create([
            'product_id' => $tintedFloat->id,
            'spec_type' => 'technical',
            'name' => 'Solar Heat Gain',
            'value' => '0.65',
            'unit' => '',
            'sort_order' => 2
        ]);

        ProductSpecification::create([
            'product_id' => $autoGlass->id,
            'spec_type' => 'technical',
            'name' => 'Annealing Stress',
            'value' => '< 15',
            'unit' => 'MPa',
            'sort_order' => 1
        ]);

        ProductSpecification::create([
            'product_id' => $ripplePattern->id,
            'spec_type' => 'size',
            'name' => 'Pattern Pitch',
            'value' => '12',
            'unit' => 'mm',
            'sort_order' => 1
        ]);

        ProductSpecification::create([
            'product_id' => $ripplePattern->id,
            'spec_type' => 'technical',
            'name' => 'Light Transmission',
            'value' => '85',
            'unit' => '%',
            'sort_order' => 2
        ]);
    }
}
