<?php

namespace Database\Seeders;

use App\Models\Department;
use Illuminate\Database\Seeder;

class DepartmentSeeder extends Seeder
{
    public function run(): void
    {
        $departments = [
            [
                'name' => 'Human Resources',
                'code' => 'HR',
                'description' => 'Manages employee relations, recruitment, and HR policies',
                'is_active' => true
            ],
            [
                'name' => 'Information Technology',
                'code' => 'IT',
                'description' => 'Manages IT infrastructure, development, and technical support',
                'is_active' => true
            ],
            [
                'name' => 'Finance',
                'code' => 'FIN',
                'description' => 'Handles financial planning, accounting, and budget management',
                'is_active' => true
            ],
            [
                'name' => 'Administration',
                'code' => 'ADMIN',
                'description' => 'General administration and management',
                'is_active' => true
            ],
            [
                'name' => 'Marketing',
                'code' => 'MKT',
                'description' => 'Marketing, advertising, and customer relations',
                'is_active' => true
            ]
        ];

        foreach ($departments as $department) {
            Department::firstOrCreate(
                ['name' => $department['name']], 
                $department
            );
        }

        $this->command->info('Default departments seeded successfully!');
    }
}