<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('material_site_transfer_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('site_transfer_id')->constrained('material_site_transfers')->onDelete('cascade');
            $table->foreignId('item_id')->constrained('items')->onDelete('restrict');
            $table->foreignId('project_inventory_id')->constrained('project_inventory')->onDelete('restrict');
            $table->decimal('quantity_transferred', 15, 3);
            $table->decimal('unit_price', 15, 2);
            $table->decimal('total_value', 15, 2);
            $table->timestamps();

            // Indexes
            $table->index(['site_transfer_id', 'item_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('material_site_transfer_items');
    }
};