<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('outgoing_items', function (Blueprint $table) {
            $table->decimal('quantity_transferred', 10, 2)->default(0)->after('quantity_balance');
            $table->enum('transfer_status', ['not_transferred', 'partially_transferred', 'fully_transferred'])
                  ->default('not_transferred')->after('quantity_transferred');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('outgoing_items', function (Blueprint $table) {
            $table->dropColumn(['quantity_transferred', 'transfer_status']);
        });
    }
};