<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('direct_deliveries', function (Blueprint $table) {
            // Update status enum to include new delivery statuses
            $table->enum('status', [
                'pending',
                'partially_delivered',
                'delivered',
                'partially_received',
                'received',
                'cancelled'
            ])->default('pending')->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('direct_deliveries', function (Blueprint $table) {
            // Revert to original enum values
            $table->enum('status', [
                'pending',
                'partially_received',
                'received',
                'cancelled'
            ])->default('pending')->change();
        });
    }
};