<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventory', function (Blueprint $table) {
            $table->id();
            $table->foreignId('item_id')->constrained('items')->onDelete('restrict');
            $table->foreignId('division_id')->constrained('departments')->onDelete('restrict');
            $table->decimal('quantity_available', 10, 2)->default(0);
            $table->decimal('unit_price', 10, 2)->default(0);
            $table->decimal('total_value', 15, 2)->default(0);
            $table->string('location', 100)->nullable();
            $table->string('batch_number', 50)->nullable();
            $table->date('production_date')->nullable();
            $table->date('expiry_date')->nullable();
            $table->enum('status', ['in_stock', 'out_of_stock', 'low_stock'])->default('in_stock');
            $table->timestamp('last_updated')->nullable();
            $table->timestamps();

            $table->index(['item_id', 'division_id']);
            $table->index('batch_number');
            $table->index('status');
            $table->index('expiry_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inventory');
    }
};
