<?php

namespace App\Http\Controllers\Warehouse;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class SettingController extends Controller
{
    /**
     * Display warehouse settings dashboard.
     */
    public function index()
    {
        // Get current settings (you can implement actual settings retrieval later)
        $settings = [
            'general' => [
                'warehouse_name' => 'Main Warehouse',
                'default_currency' => 'AED',
                'timezone' => 'Asia/Dubai',
                'auto_approve_returns' => false,
                'require_approval_threshold' => 10000,
            ],
            'notifications' => [
                'low_stock_alert' => true,
                'approval_required' => true,
                'daily_reports' => false,
                'email_notifications' => true,
                'sms_notifications' => false,
            ],
            'workflows' => [
                'auto_create_delivery_notes' => true,
                'require_quality_inspection' => true,
                'enable_barcode_scanning' => false,
                'auto_update_inventory' => true,
                'require_supervisor_approval' => true,
            ]
        ];

        return view('warehouse.settings.index', compact('settings'));
    }

    /**
     * Update general settings.
     */
    public function updateGeneral(Request $request)
    {
        $request->validate([
            'warehouse_name' => 'required|string|max:255',
            'default_currency' => 'required|string|in:AED,USD,EUR',
            'timezone' => 'required|string',
            'auto_approve_returns' => 'boolean',
            'require_approval_threshold' => 'required|numeric|min:0',
        ]);

        // Here you would typically save to a settings table or config
        // For now, we'll just redirect back with success message

        return back()->with('success', 'General settings updated successfully.');
    }

    /**
     * Update notification settings.
     */
    public function updateNotifications(Request $request)
    {
        $request->validate([
            'low_stock_alert' => 'boolean',
            'approval_required' => 'boolean',
            'daily_reports' => 'boolean',
            'email_notifications' => 'boolean',
            'sms_notifications' => 'boolean',
        ]);

        // Here you would typically save to a settings table or config

        return back()->with('success', 'Notification settings updated successfully.');
    }

    /**
     * Update workflow settings.
     */
    public function updateWorkflows(Request $request)
    {
        $request->validate([
            'auto_create_delivery_notes' => 'boolean',
            'require_quality_inspection' => 'boolean',
            'enable_barcode_scanning' => 'boolean',
            'auto_update_inventory' => 'boolean',
            'require_supervisor_approval' => 'boolean',
        ]);

        // Here you would typically save to a settings table or config

        return back()->with('success', 'Workflow settings updated successfully.');
    }
}