<?php
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(\Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = \Illuminate\Http\Request::capture()
);

use App\Models\DirectDelivery;
use App\Models\DirectDeliveryItem;
use App\Models\Warehouse\OutgoingTransaction;
use App\Models\Warehouse\OutgoingFulfillment;

echo "=== DIRECT DELIVERY REFERENCE LINKING TEST ===\n\n";

// Test the updated direct delivery
$directDelivery = DirectDelivery::with(['items.item', 'project'])->find(5);

if ($directDelivery) {
    echo "Direct Delivery Information:\n";
    echo "- ID: " . $directDelivery->id . "\n";
    echo "- Delivery Number: " . $directDelivery->delivery_number . "\n";
    echo "- Reference Number: " . $directDelivery->reference_number . "\n";
    echo "- Material Request Number: " . $directDelivery->material_request_number . "\n";
    echo "- Outgoing Transaction ID: " . $directDelivery->outgoing_transaction_id . "\n";
    echo "- Project: " . $directDelivery->project->project_name . " (ID: " . $directDelivery->project_id . ")\n";
    echo "- Status: " . $directDelivery->status . "\n";
    echo "- Workflow Status: " . $directDelivery->workflow_status . "\n\n";

    echo "Direct Delivery Items:\n";
    foreach ($directDelivery->items as $item) {
        echo "- " . $item->item->item_code . ": " . $item->quantity_ordered . " units\n";
    }

    // Check if we can trace back to the original material request
    if ($directDelivery->outgoing_transaction_id) {
        $originalTransaction = OutgoingTransaction::with('items.item')->find($directDelivery->outgoing_transaction_id);

        if ($originalTransaction) {
            echo "\nOriginal Material Request (Linked):\n";
            echo "- Transaction ID: " . $originalTransaction->id . "\n";
            echo "- Material Request Number: " . $originalTransaction->material_request_number . "\n";
            echo "- Status: " . $originalTransaction->status . "\n";
            echo "- Created: " . $originalTransaction->created_at . "\n";

            echo "\nOriginal Request Items:\n";
            foreach ($originalTransaction->items as $item) {
                echo "- " . $item->item->item_code . ": " . $item->quantity_requested . " units requested\n";
            }
        }
    }

    // Check fulfillment records
    $fulfillments = OutgoingFulfillment::where('reference_type', 'DirectDelivery')
        ->where('reference_id', $directDelivery->id)
        ->get();

    echo "\nFulfillment Records:\n";
    foreach ($fulfillments as $fulfillment) {
        echo "- Item " . $fulfillment->item_id . ": " . $fulfillment->quantity_fulfilled . " units (" . $fulfillment->fulfillment_type . ")\n";
        echo "  Links back to transaction: " . $fulfillment->outgoing_transaction_id . "\n";
    }

    echo "\n=== REFERENCE TRACEABILITY COMPLETE ===\n";
    echo "✅ Direct delivery is properly linked to original material request\n";
    echo "✅ Can trace back from direct delivery to original transaction\n";
    echo "✅ Fulfillment records link direct delivery to original request\n";

} else {
    echo "Direct delivery not found.\n";
}