<?php $__env->startSection('title', 'Create Material Request'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('warehouse.outgoing.index')); ?>">Material Requests</a></li>
    <li class="breadcrumb-item active">Create</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Create Material Request</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Request materials from inventory for project use</p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <a href="<?php echo e(route('warehouse.outgoing.index')); ?>" class="btn btn-sm btn-secondary">
                <i class="material-icons mr-1" style="font-size: 16px;">arrow_back</i>
                Back to List
            </a>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style>
    .pulse-error {
        animation: pulse-red 1s ease-in-out 3;
        border-color: #dc3545 !important;
    }

    @keyframes pulse-red {
        0% {
            box-shadow: 0 0 0 0 rgba(220, 53, 69, 0.7);
        }
        70% {
            box-shadow: 0 0 0 10px rgba(220, 53, 69, 0);
        }
        100% {
            box-shadow: 0 0 0 0 rgba(220, 53, 69, 0);
        }
    }

    .select2-container .select2-selection.pulse-error {
        animation: pulse-red 1s ease-in-out 3;
        border-color: #dc3545 !important;
    }

    /* Force Select2 dropdown to appear below */
    .select2-container--open .select2-dropdown {
        top: 100% !important;
        bottom: auto !important;
        margin-top: 1px !important;
    }

    /* Force dropdown direction to be below */
    .select2-container--open .select2-dropdown--below {
        top: 100% !important;
        border-top: none !important;
        border-top-left-radius: 0 !important;
        border-top-right-radius: 0 !important;
    }

    /* Hide dropdown above option */
    .select2-container--open .select2-dropdown--above {
        display: none !important;
    }

    /* Custom width for item selection dropdowns */
    #items-table .select2-container {
        width: 80% !important;
        max-width: 400px !important;
        min-width: 250px !important;
    }

    /* Custom width for requested by dropdown */
    #requested_by + .select2-container {
        width: 60% !important;
        max-width: 300px !important;
        min-width: 200px !important;
    }

    /* Custom width for project dropdown */
    #project_id + .select2-container {
        width: 70% !important;
        max-width: 450px !important;
        min-width: 280px !important;
    }

    /* General Select2 width fix for form dropdowns */
    .form-group .select2-container {
        width: 60% !important;
        max-width: 300px !important;
        min-width: 200px !important;
    }

    /* Exception for project dropdown to be wider */
    .form-group #project_id + .select2-container {
        width: 70% !important;
        max-width: 450px !important;
        min-width: 280px !important;
    }

    /* Ensure dropdown doesn't get cut off */
    .table-responsive {
        overflow: visible !important;
    }

    #items-table {
        overflow: visible !important;
    }

    /* Specific positioning for item dropdowns in table */
    #items-tbody .select2-container {
        position: relative !important;
    }

    #items-tbody .select2-dropdown {
        position: absolute !important;
        top: 100% !important;
        z-index: 9999 !important;
        width: 100% !important;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Main Container -->
    <div class="card shadow">
        <div class="card-header">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="material-icons align-middle mr-1">assignment</i>
                Material Request Form
            </h6>
        </div>
        <div class="card-body">
            <form action="<?php echo e(route('warehouse.outgoing.store')); ?>" method="POST" id="materialRequestForm" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>

                <!-- Request Information -->
                <div class="row mb-4">
                    <div class="col-12">
                        <h6 class="font-weight-bold text-secondary mb-3">
                            <i class="material-icons align-middle mr-1">info</i>
                            Request Information
                        </h6>
                        <div class="row">
                            <!-- Date -->
                            <div class="col-md-4 mb-3">
                                <label for="request_date" class="form-label">Request Date <span class="text-danger">*</span></label>
                                <input type="date"
                                       class="form-control <?php $__errorArgs = ['request_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       id="request_date"
                                       name="request_date"
                                       value="<?php echo e(old('request_date', date('Y-m-d'))); ?>"
                                       required>
                                <?php $__errorArgs = ['request_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Material Request Number -->
                            <div class="col-md-4 mb-3">
                                <label for="material_request_number" class="form-label">Material Request Number <span class="text-danger">*</span></label>
                                <input type="text"
                                       class="form-control <?php $__errorArgs = ['material_request_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       id="material_request_number"
                                       name="material_request_number"
                                       value="<?php echo e(old('material_request_number', 'MR-' . date('Ymd') . '-' . str_pad(rand(1, 999), 3, '0', STR_PAD_LEFT))); ?>"
                                       placeholder="Auto-generated request number"
                                       required>
                                <?php $__errorArgs = ['material_request_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Requested By -->
                            <div class="col-md-4 mb-3">
                                <?php if (isset($component)) { $__componentOriginal6c49fce73979297b67c6317948ab8eae = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6c49fce73979297b67c6317948ab8eae = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.select2-dropdown','data' => ['name' => 'requested_by','id' => 'requested_by','label' => 'Requested By','placeholder' => 'Select Requester','options' => isset($users) ? $users->map(function($user) {
                                        return ['value' => $user->id, 'text' => $user->name];
                                    }) : [],'selected' => old('requested_by'),'required' => true,'allowClear' => 'true']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.select2-dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'requested_by','id' => 'requested_by','label' => 'Requested By','placeholder' => 'Select Requester','options' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(isset($users) ? $users->map(function($user) {
                                        return ['value' => $user->id, 'text' => $user->name];
                                    }) : []),'selected' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(old('requested_by')),'required' => true,'allowClear' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $attributes = $__attributesOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__attributesOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $component = $__componentOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__componentOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Project -->
                            <div class="col-md-8 mb-3">
                                <?php if (isset($component)) { $__componentOriginal6c49fce73979297b67c6317948ab8eae = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6c49fce73979297b67c6317948ab8eae = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.select2-dropdown','data' => ['name' => 'project_id','id' => 'project_id','label' => 'Project Number & Name','placeholder' => 'Select Project','options' => isset($projects) ? $projects->map(function($project) {
                                        return [
                                            'value' => $project->id,
                                            'text' => $project->project_number . ' - ' . $project->project_name,
                                            'data' => [
                                                'division' => $project->project_division_id ?? '',
                                                'division-name' => $project->projectDivision->division_name ?? ''
                                            ]
                                        ];
                                    }) : [],'selected' => old('project_id'),'required' => true,'allowClear' => 'true']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.select2-dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'project_id','id' => 'project_id','label' => 'Project Number & Name','placeholder' => 'Select Project','options' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(isset($projects) ? $projects->map(function($project) {
                                        return [
                                            'value' => $project->id,
                                            'text' => $project->project_number . ' - ' . $project->project_name,
                                            'data' => [
                                                'division' => $project->project_division_id ?? '',
                                                'division-name' => $project->projectDivision->division_name ?? ''
                                            ]
                                        ];
                                    }) : []),'selected' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(old('project_id')),'required' => true,'allowClear' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $attributes = $__attributesOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__attributesOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $component = $__componentOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__componentOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>

                                <!-- Division Display Box -->
                                <div id="division_display" class="mt-2" style="display: none;">
                                    <div class="alert alert-info py-2 mb-0">
                                        <strong>Division:</strong> <span id="division_name_display"></span>
                                    </div>
                                </div>
                            </div>

                            <!-- Request File -->
                            <div class="col-md-4 mb-3">
                                <label for="request_file" class="form-label">Request File</label>
                                <input type="file"
                                       class="form-control <?php $__errorArgs = ['request_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       id="request_file"
                                       name="request_file"
                                       accept=".pdf,.doc,.docx,.jpg,.jpeg,.png"
                                       value="<?php echo e(old('request_file')); ?>">
                                <small class="form-text text-muted">Upload supporting document (PDF, DOC, DOCX, JPG, PNG)</small>
                                <?php $__errorArgs = ['request_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                    </div>
                </div>

                <hr class="my-4">

                <!-- Items Section -->
                <div class="row">
                    <div class="col-12">
                        <h6 class="font-weight-bold text-secondary mb-3">
                            <i class="material-icons align-middle mr-1">shopping_cart</i>
                            Items Selection & Management
                        </h6>

                        <!-- Items Table -->
                        <div class="table-responsive">
                            <table class="table table-bordered" id="items-table">
                                <thead class="thead-light">
                                    <tr>
                                        <th width="50%">Item</th>
                                        <th width="25%">Requested Qty</th>
                                        <th width="20%">Unit</th>
                                        <th width="5%">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="items-tbody">
                                    <tr>
                                        <td>
                                            <select name="items[0][item_id]" id="item_select_0" class="form-control item-select select2-ajax" onchange="updateItemRow(this, 0)" required>
                                                <option value="">Select Item</option>
                                            </select>
                                        </td>
                                        <td>
                                            <input type="number" name="items[0][quantity_requested]" class="form-control" step="0.01" min="0.01" required>
                                        </td>
                                        <td>
                                            <input type="text" name="items[0][unit_of_measure]" class="form-control" readonly>
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-sm btn-outline-danger" onclick="removeItemRow(this)">
                                                <i class="material-icons">delete</i>
                                            </button>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <!-- Add Row Button -->
                        <div class="mb-3">
                            <button type="button" class="btn btn-outline-primary" onclick="addItemRow()">
                                <i class="material-icons mr-1">add</i>
                                Add Another Item
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Form Actions -->
                <hr class="my-4">
                <div class="row">
                    <div class="col-12">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="text-muted">
                                <i class="material-icons align-middle mr-1">info</i>
                                <strong>Summary:</strong> <span id="total_items_display">0 items</span>
                            </div>
                            <div>
                                <a href="<?php echo e(route('warehouse.outgoing.index')); ?>" class="btn btn-outline-secondary mr-2">
                                    <i class="material-icons mr-1">arrow_back</i>
                                    Cancel
                                </a>
                                <button type="submit" class="btn btn-success" id="submit_request_btn" disabled>
                                    <i class="material-icons mr-1">send</i>
                                    Submit Material Request
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
let rowCounter = 1;

$(document).ready(function() {
    console.log('🚀 Material Request Form: Initializing...');

    // Project selection change handler
    $('#project_id').off('change.materialRequest').on('change.materialRequest', function() {
        const selectedOption = $(this).find('option:selected');
        const divisionDisplay = $('#division_display');
        const divisionNameDisplay = $('#division_name_display');

        if (selectedOption.val() && selectedOption.data('division-name')) {
            divisionNameDisplay.text(selectedOption.data('division-name'));
            divisionDisplay.show();
        } else {
            divisionDisplay.hide();
        }
    });

    // Form submission validation
    $('#materialRequestForm').off('submit.materialRequest').on('submit.materialRequest', function(e) {
        console.log('📋 Form submission triggered');

        // Validate required fields
        let isValid = true;
        let missingFields = [];

        // Check request date
        if (!$('#request_date').val()) {
            isValid = false;
            missingFields.push('Request Date');
            $('#request_date').addClass('is-invalid');
        } else {
            $('#request_date').removeClass('is-invalid');
        }

        // Check material request number
        if (!$('#material_request_number').val()) {
            isValid = false;
            missingFields.push('Material Request Number');
            $('#material_request_number').addClass('is-invalid');
        } else {
            $('#material_request_number').removeClass('is-invalid');
        }

        // Check project selection
        if (!$('#project_id').val()) {
            isValid = false;
            missingFields.push('Project');
            $('#project_id').next('.select2-container').find('.select2-selection').addClass('is-invalid');
        } else {
            $('#project_id').next('.select2-container').find('.select2-selection').removeClass('is-invalid');
        }

        // Check requested by
        if (!$('#requested_by').val()) {
            isValid = false;
            missingFields.push('Requested By');
            $('#requested_by').next('.select2-container').find('.select2-selection').addClass('is-invalid');
        } else {
            $('#requested_by').next('.select2-container').find('.select2-selection').removeClass('is-invalid');
        }

        // Check if there are items
        const hasItems = $('#items-tbody tr').length > 0;
        if (!hasItems) {
            isValid = false;
            missingFields.push('Items');
        } else {
            // Check for duplicate items
            const selectedItems = [];
            let hasDuplicates = false;

            $('#items-tbody tr').each(function(index) {
                const itemSelect = $(this).find('select[name*="item_id"]');
                const itemId = itemSelect.val();

                if (itemId && selectedItems.includes(itemId)) {
                    hasDuplicates = true;
                    isValid = false;
                    itemSelect.addClass('pulse-error');
                    setTimeout(() => {
                        itemSelect.removeClass('pulse-error');
                    }, 3000);
                } else if (itemId) {
                    selectedItems.push(itemId);
                }
            });

            if (hasDuplicates) {
                missingFields.push('Duplicate items detected');
            }

            // Validate each item row
            $('#items-tbody tr').each(function(index) {
                const itemSelect = $(this).find('select[name*="item_id"]');
                const quantityInput = $(this).find('input[name*="quantity_requested"]');

                if (!itemSelect.val()) {
                    isValid = false;
                    missingFields.push(`Item selection in row ${index + 1}`);
                    itemSelect.addClass('is-invalid');
                    itemSelect.next('.select2-container').find('.select2-selection').addClass('is-invalid');
                } else {
                    itemSelect.removeClass('is-invalid');
                    itemSelect.next('.select2-container').find('.select2-selection').removeClass('is-invalid');
                }

                if (!quantityInput.val() || quantityInput.val() <= 0) {
                    isValid = false;
                    missingFields.push(`Quantity in row ${index + 1}`);
                    quantityInput.addClass('is-invalid');
                } else {
                    quantityInput.removeClass('is-invalid');
                }
            });
        }

        if (!isValid) {
            e.preventDefault();
            alert('Please fill in the following required fields:\n\n• ' + missingFields.join('\n• '));

            // Focus on the first missing field and scroll to it
            setTimeout(function() {
                if (!$('#request_date').val()) {
                    $('#request_date').addClass('pulse-error').focus();
                    $('html, body').animate({scrollTop: $('#request_date').offset().top - 100}, 500);
                    setTimeout(() => $('#request_date').removeClass('pulse-error'), 3000);
                } else if (!$('#material_request_number').val()) {
                    $('#material_request_number').addClass('pulse-error').focus();
                    $('html, body').animate({scrollTop: $('#material_request_number').offset().top - 100}, 500);
                    setTimeout(() => $('#material_request_number').removeClass('pulse-error'), 3000);
                } else if (!$('#project_id').val()) {
                    $('#project_id').next('.select2-container').find('.select2-selection').addClass('pulse-error');
                    $('#project_id').select2('open');
                    $('html, body').animate({scrollTop: $('#project_id').offset().top - 100}, 500);
                    setTimeout(() => $('#project_id').next('.select2-container').find('.select2-selection').removeClass('pulse-error'), 3000);
                } else if (!$('#requested_by').val()) {
                    $('#requested_by').next('.select2-container').find('.select2-selection').addClass('pulse-error');
                    $('#requested_by').select2('open');
                    $('html, body').animate({scrollTop: $('#requested_by').offset().top - 100}, 500);
                    setTimeout(() => $('#requested_by').next('.select2-container').find('.select2-selection').removeClass('pulse-error'), 3000);
                } else {
                    // Focus on first invalid item field
                    const firstInvalidItem = $('#items-tbody tr').first().find('select[name*="item_id"]');
                    if (firstInvalidItem.length) {
                        firstInvalidItem.next('.select2-container').find('.select2-selection').addClass('pulse-error');
                        firstInvalidItem.select2('open');
                        $('html, body').animate({scrollTop: firstInvalidItem.offset().top - 100}, 500);
                        setTimeout(() => firstInvalidItem.next('.select2-container').find('.select2-selection').removeClass('pulse-error'), 3000);
                    }
                }
            }, 100);

            return false;
        }

        console.log('✅ Form validation passed, submitting...');
    });

    // Initialize Select2 for the first item row
    initializeSelect2ForRow(0);

    // Enable submit button initially since we have one row
    updateSubmitButton();

    // Add click handler to submit button for debugging
    $('#submit_request_btn').off('click.debug').on('click.debug', function(e) {
        console.log('🖱️ Submit button clicked');
        const isDisabled = $(this).prop('disabled');
        if (isDisabled) {
            console.log('⚠️ Button is disabled');
            e.preventDefault();
            return false;
        }
        console.log('✅ Button click proceeding');
    });

    // Add event listeners to clear validation errors when user interacts with fields
    $('#request_date').on('change', function() {
        $(this).removeClass('is-invalid');
    });

    $('#material_request_number').on('input', function() {
        if ($(this).val()) {
            $(this).removeClass('is-invalid');
        }
    });

    $('#project_id').on('select2:select', function() {
        $(this).next('.select2-container').find('.select2-selection').removeClass('is-invalid');
    });

    $('#requested_by').on('select2:select', function() {
        $(this).next('.select2-container').find('.select2-selection').removeClass('is-invalid');
    });

    // Add event listener for quantity inputs (using event delegation)
    $(document).on('input', 'input[name*="quantity_requested"]', function() {
        if ($(this).val() && $(this).val() > 0) {
            $(this).removeClass('is-invalid');
        }
    });

    // Add event listener for item select changes (using event delegation)
    $(document).on('select2:select', 'select[name*="item_id"]', function() {
        $(this).removeClass('is-invalid');
        $(this).next('.select2-container').find('.select2-selection').removeClass('is-invalid');
    });

    console.log('✅ Material Request Form: Initialization complete');
});


// Update submit button state
function updateSubmitButton() {
    const hasRows = $('#items-tbody tr').length > 0;
    const submitBtn = $('#submit_request_btn');

    console.log('🔘 Updating submit button - Rows:', hasRows, 'Button found:', submitBtn.length > 0);

    if (hasRows) {
        submitBtn.prop('disabled', false);
        console.log('✅ Submit button enabled');
    } else {
        submitBtn.prop('disabled', true);
        console.log('❌ Submit button disabled');
    }
}

// Update item row when item is selected
function updateItemRow(selectElement, rowIndex) {
    const selectedItemId = selectElement.value;

    if (selectedItemId) {
        // Check for duplicate items
        const allItemSelects = document.querySelectorAll('.item-select');
        let isDuplicate = false;

        allItemSelects.forEach(function(select) {
            if (select !== selectElement && select.value === selectedItemId) {
                isDuplicate = true;
            }
        });

        if (isDuplicate) {
            alert('This item has already been added to the request. Please select a different item.');
            $(selectElement).val('').trigger('change');
            const unitInput = selectElement.closest('tr').querySelector('input[name*="unit_of_measure"]');
            if (unitInput) {
                unitInput.value = '';
            }
            $(selectElement).next('.select2-container').find('.select2-selection').addClass('pulse-error');
            setTimeout(() => {
                $(selectElement).next('.select2-container').find('.select2-selection').removeClass('pulse-error');
            }, 3000);
            return;
        }

        // Get data from Select2's data
        const selectedData = $(selectElement).select2('data')[0];
        const unit = selectedData ? selectedData.unit_of_measure || '' : '';

        // Update unit
        const unitInput = selectElement.closest('tr').querySelector('input[name*="unit_of_measure"]');
        if (unitInput) {
            unitInput.value = unit;
        }

        // Remove error styling if item is selected
        $(selectElement).removeClass('is-invalid');
        $(selectElement).next('.select2-container').find('.select2-selection').removeClass('is-invalid');
    } else {
        // Clear fields when no item selected
        const unitInput = selectElement.closest('tr').querySelector('input[name*="unit_of_measure"]');
        if (unitInput) {
            unitInput.value = '';
        }
    }
}


// Add a new item row
function addItemRow() {
    const tbody = document.getElementById('items-tbody');
    const newRow = document.createElement('tr');

    newRow.innerHTML = `
        <td>
            <select name="items[${rowCounter}][item_id]" id="item_select_${rowCounter}" class="form-control item-select select2-ajax" onchange="updateItemRow(this, ${rowCounter})" required>
                <option value="">Select Item</option>
            </select>
        </td>
        <td>
            <input type="number" name="items[${rowCounter}][quantity_requested]" class="form-control" step="0.01" min="0.01" required>
        </td>
        <td>
            <input type="text" name="items[${rowCounter}][unit_of_measure]" class="form-control" readonly>
        </td>
        <td>
            <button type="button" class="btn btn-sm btn-outline-danger" onclick="removeItemRow(this)">
                <i class="material-icons">delete</i>
            </button>
        </td>
    `;

    tbody.appendChild(newRow);

    // Initialize Select2 for the new dropdown
    initializeSelect2ForRow(rowCounter);

    rowCounter++;

    // Update submit button state
    updateSubmitButton();
}

// Initialize Select2 for a specific row with AJAX
function initializeSelect2ForRow(rowIndex) {
    const selectId = `#item_select_${rowIndex}`;

    // Initialize Select2 with AJAX
    $(selectId).select2({
        placeholder: 'Search for items...',
        allowClear: true,
        theme: 'default',
        width: '80%',
        dropdownAutoWidth: false,
        minimumInputLength: 2,
        ajax: {
            url: '<?php echo e(route("warehouse.outgoing.search-items")); ?>',
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term,
                    page: params.page || 1
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                
                return {
                    results: data.results.map(item => ({
                        id: item.id,
                        text: item.text,
                        item_code: item.item_code,
                        item_description: item.item_description,
                        unit_of_measure: item.unit_of_measure,
                        current_stock: item.current_stock
                    })),
                    pagination: {
                        more: data.pagination.more
                    }
                };
            },
            cache: true
        },
        language: {
            inputTooShort: function() {
                return 'Please enter 2 or more characters to search';
            },
            searching: function() {
                return 'Searching items...';
            },
            noResults: function() {
                return 'No items found';
            },
            loadingMore: function() {
                return 'Loading more items...';
            }
        },
        dropdownCssClass: 'select2-dropdown-below',
        adaptDropdownCssClass: function(cssClass) {
            return 'select2-dropdown-below';
        }
    });

    // Force dropdown to open below
    $(selectId).on('select2:open', function() {
        const dropdown = $('.select2-dropdown');
        dropdown.removeClass('select2-dropdown--above').addClass('select2-dropdown--below');
        dropdown.css({
            'top': '100%',
            'bottom': 'auto'
        });
    });

    // Prevent Select2 events from interfering with Bootstrap dropdowns
    $(selectId).on('select2:open select2:close', function(e) {
        e.stopPropagation();
    });

    // Handle dropdown clicks to prevent Bootstrap dropdown interference
    $(selectId).next('.select2-container').on('click', function(e) {
        e.stopPropagation();
    });
}

// Remove an item row
function removeItemRow(button) {
    const tbody = document.getElementById('items-tbody');
    const rowToRemove = button.closest('tr');

    // Don't allow removing the last row
    if (tbody.children.length > 1) {
        // Find and destroy Select2 instance before removing the row
        const selectElement = rowToRemove.querySelector('select.select2-dropdown');
        if (selectElement && $(selectElement).hasClass('select2-hidden-accessible')) {
            $(selectElement).select2('destroy');
        }
        rowToRemove.remove();
    } else {
        alert('At least one item row is required');
    }

    // Update submit button state
    updateSubmitButton();
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/outgoing/create.blade.php ENDPATH**/ ?>