<?php $__env->startSection('title', 'Create Site Transfer'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('warehouse.site-transfers.index')); ?>">Site Transfers</a></li>
    <li class="breadcrumb-item active">Create</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Create Site Transfer</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Transfer materials between project sites</p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <a href="<?php echo e(route('warehouse.site-transfers.index')); ?>" class="btn btn-sm btn-secondary">
                <i class="material-icons mr-1" style="font-size: 16px;">arrow_back</i>
                Back to List
            </a>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@ttskch/select2-bootstrap4-theme@x.x.x/dist/select2-bootstrap4.min.css">

<style>
    .pulse-error {
        animation: pulse-red 1s ease-in-out 3;
        border-color: #dc3545 !important;
    }

    @keyframes pulse-red {
        0% {
            box-shadow: 0 0 0 0 rgba(220, 53, 69, 0.7);
        }
        70% {
            box-shadow: 0 0 0 10px rgba(220, 53, 69, 0);
        }
        100% {
            box-shadow: 0 0 0 0 rgba(220, 53, 69, 0);
        }
    }

    .select2-container .select2-selection.pulse-error {
        animation: pulse-red 1s ease-in-out 3;
        border-color: #dc3545 !important;
    }

    /* Select2 Bootstrap 4 theme customizations */
    .select2-container--bootstrap4 .select2-selection--single {
        height: calc(1.5em + .75rem + 2px);
        padding: .375rem .75rem;
    }

    .select2-container--bootstrap4 .select2-selection--single .select2-selection__rendered {
        padding-left: 0;
        padding-right: 0;
    }

    .select2-container--bootstrap4 .select2-selection--single .select2-selection__arrow {
        right: 3px;
        width: 20px;
    }

    .select2-container--bootstrap4 .select2-dropdown {
        border-color: #ced4da;
        border-radius: 0 0 .25rem .25rem;
    }

    .select2-container--bootstrap4 .select2-dropdown .select2-search__field {
        border: 1px solid #ced4da;
        border-radius: .25rem;
    }

    /* Force Select2 dropdown to appear below */
    .select2-container--open .select2-dropdown {
        top: 100% !important;
        bottom: auto !important;
        margin-top: 1px !important;
        z-index: 9999;
    }

    /* Force dropdown direction to be below */
    .select2-container--open .select2-dropdown--below {
        top: 100% !important;
        border-top: none !important;
        border-top-left-radius: 0 !important;
        border-top-right-radius: 0 !important;
    }

    /* Hide dropdown above option */
    .select2-container--open .select2-dropdown--above {
        display: none !important;
    }

    /* Custom width for item selection dropdowns */
    #items-table .select2-container {
        width: 100% !important;
    }

    /* Ensure dropdown doesn't get cut off */
    .table-responsive {
        overflow: visible !important;
    }

    #items-table {
        overflow: visible !important;
    }

    .item-row {
        background-color: #f8f9fa;
        border-radius: 8px;
        margin-bottom: 10px;
        padding: 15px;
        border: 1px solid #dee2e6;
    }

    .allocation-badge {
        background: #007bff;
        color: white;
        padding: 4px 8px;
        border-radius: 12px;
        font-size: 11px;
        font-weight: 500;
    }

    .btn-allocate {
        background: #007bff !important;
        border-color: #007bff !important;
        color: white !important;
        font-size: 12px;
        padding: 6px 12px;
        font-weight: 500;
        border: 1px solid #007bff !important;
        display: inline-flex;
        align-items: center;
        gap: 4px;
    }

    .btn-allocate:hover,
    .btn-allocate:focus,
    .btn-allocate:active {
        background: #0056b3 !important;
        border-color: #004085 !important;
        color: white !important;
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
    }

    /* Loading state for items section */
    .items-loading {
        text-align: center;
        padding: 40px;
        color: #6c757d;
    }

    .items-empty {
        text-align: center;
        padding: 40px;
        color: #6c757d;
        background: #f8f9fa;
        border-radius: 8px;
        border: 2px dashed #dee2e6;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Status Messages -->
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="material-icons align-middle mr-1">check_circle</i>
            <?php echo e(session('success')); ?>

            <button type="button" class="close" data-dismiss="alert">
                <span>&times;</span>
            </button>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="material-icons align-middle mr-1">error</i>
            <?php echo e(session('error')); ?>

            <button type="button" class="close" data-dismiss="alert">
                <span>&times;</span>
            </button>
        </div>
    <?php endif; ?>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="material-icons align-middle mr-1">error</i>
            <strong>Please fix the following errors:</strong>
            <ul class="mb-0 mt-2">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
            <button type="button" class="close" data-dismiss="alert">
                <span>&times;</span>
            </button>
        </div>
    <?php endif; ?>

    <!-- Main Container -->
    <div class="card shadow">
        <div class="card-header">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="material-icons align-middle mr-1">swap_horiz</i>
                Site Transfer Form
            </h6>
        </div>
        <div class="card-body">
            <form action="<?php echo e(route('warehouse.site-transfers.store')); ?>" method="POST" id="siteTransferForm" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>

                <!-- Transfer Information -->
                <div class="row mb-4">
                    <div class="col-12">
                        <h6 class="font-weight-bold text-secondary mb-3">
                            <i class="material-icons align-middle mr-1">info</i>
                            Transfer Information
                        </h6>
                        <div class="row">
                            <!-- Transfer Date -->
                            <div class="col-md-6 mb-3">
                                <label for="transfer_date" class="form-label">Transfer Date <span class="text-danger">*</span></label>
                                <input type="date"
                                       class="form-control <?php $__errorArgs = ['transfer_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                       id="transfer_date"
                                       name="transfer_date"
                                       value="<?php echo e(old('transfer_date', date('Y-m-d'))); ?>"
                                       required>
                                <?php $__errorArgs = ['transfer_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Notes -->
                            <div class="col-md-6 mb-3">
                                <label for="notes" class="form-label">Notes</label>
                                <textarea class="form-control <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                         id="notes"
                                         name="notes"
                                         rows="3"
                                         placeholder="Optional transfer notes..."><?php echo e(old('notes')); ?></textarea>
                                <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="row">
                            <!-- From Project -->
                            <div class="col-md-6 mb-3">
                                <label for="from_project_id" class="form-label">From Project <span class="text-danger">*</span></label>
                                <select name="from_project_id" id="from_project_id" class="form-control select2 <?php $__errorArgs = ['from_project_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        data-placeholder="Select source project..." required>
                                    <option value=""></option>
                                    <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($project->id); ?>" <?php echo e(old('from_project_id') == $project->id ? 'selected' : ''); ?>>
                                            <?php echo e($project->project_number ? $project->project_number . ' - ' : ''); ?><?php echo e($project->project_name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['from_project_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- To Project -->
                            <div class="col-md-6 mb-3">
                                <label for="to_project_id" class="form-label">To Project <span class="text-danger">*</span></label>
                                <select name="to_project_id" id="to_project_id" class="form-control select2 <?php $__errorArgs = ['to_project_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        data-placeholder="Select destination project..." required>
                                    <option value=""></option>
                                    <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($project->id); ?>" <?php echo e(old('to_project_id') == $project->id ? 'selected' : ''); ?>>
                                            <?php echo e($project->project_number ? $project->project_number . ' - ' : ''); ?><?php echo e($project->project_name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['to_project_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Available Items Section -->
                <div class="row mb-4" id="itemsSection" style="display: none;">
                    <div class="col-12">
                        <h6 class="font-weight-bold text-secondary mb-3">
                            <i class="material-icons align-middle mr-1">inventory</i>
                            Available Items
                            <small class="text-muted ms-2" id="itemsCount">(Select a source project)</small>
                        </h6>

                        <div class="alert alert-info">
                            <i class="material-icons align-middle mr-1">info</i>
                            Select items from the source project and click "Allocate" to specify transfer quantities.
                        </div>

                        <div class="table-responsive" id="itemsTableContainer">
                            <table class="table table-bordered table-hover" id="items-table">
                                <thead class="thead-light">
                                    <tr>
                                        <th width="15%">Item Code</th>
                                        <th width="35%">Item Name</th>
                                        <th width="15%">Available Stock</th>
                                        <th width="15%">Unit</th>
                                        <th width="20%">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="items-tbody">
                                    <!-- Items will be loaded here -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Selected Items Section -->
                <div class="row mb-4" id="selectedItemsSection" style="display: none;">
                    <div class="col-12">
                        <h6 class="font-weight-bold text-secondary mb-3">
                            <i class="material-icons align-middle mr-1">shopping_cart</i>
                            Selected Items for Transfer
                            <span class="badge badge-primary ms-2" id="selectedItemsCount">0</span>
                        </h6>

                        <div id="selectedItemsList">
                            <!-- Selected items will be displayed here -->
                        </div>
                    </div>
                </div>

                <!-- Form Actions -->
                <div class="row">
                    <div class="col-12">
                        <div class="d-flex justify-content-end">
                            <a href="<?php echo e(route('warehouse.site-transfers.index')); ?>" class="btn btn-secondary mr-2">
                                <i class="material-icons mr-1" style="font-size: 16px;">cancel</i>
                                Cancel
                            </a>
                            <button type="submit" class="btn btn-primary" id="submitBtn" disabled>
                                <i class="material-icons mr-1" style="font-size: 16px;">send</i>
                                Complete Transfer
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<!-- Allocation Modal -->
<div class="modal fade" id="allocationModal" tabindex="-1" role="dialog" aria-labelledby="allocationModalLabel" aria-hidden="true" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="allocationModalLabel">
                    <i class="material-icons align-middle mr-1">ballot</i>
                    Item Allocation Details
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div id="allocationContent">
                    <!-- Content will be loaded here -->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="confirmAllocation">Confirm Allocation</button>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
$(document).ready(function() {
    let selectedItems = {};
    let allocationData = {};

    // Initialize Select2 with proper configuration
    $('#from_project_id').select2({
        theme: 'bootstrap4',
        width: '100%',
        allowClear: true,
        placeholder: 'Select source project...',
        minimumResultsForSearch: 0 // Always show search box
    });

    $('#to_project_id').select2({
        theme: 'bootstrap4',
        width: '100%',
        allowClear: true,
        placeholder: 'Select destination project...',
        minimumResultsForSearch: 0 // Always show search box
    });

    console.log('Select2 initialized for project dropdowns'); // Debug log

    // Load items when from project changes
    $('#from_project_id').on('change', function() {
        const projectId = $(this).val();
        console.log('From project changed:', projectId); // Debug log
        if (projectId) {
            loadProjectItems(projectId);
        } else {
            $('#itemsSection').hide();
            $('#itemsCount').text('(Select a source project)');
            clearSelectedItems();
        }
    });

    function loadProjectItems(projectId) {
        console.log('Loading items for project:', projectId); // Debug log

        $.ajax({
            url: '<?php echo e(route("warehouse.site-transfers.project-inventory")); ?>',
            method: 'GET',
            data: { project_id: projectId },
            beforeSend: function() {
                console.log('Before send - showing loading state'); // Debug log
                $('#items-tbody').html(`
                    <tr>
                        <td colspan="6" class="items-loading">
                            <div class="spinner-border spinner-border-sm text-primary" role="status">
                                <span class="sr-only">Loading...</span>
                            </div>
                            <div class="mt-2">Loading items...</div>
                        </td>
                    </tr>
                `);
                $('#itemsSection').show();
                $('#itemsCount').text('Loading...');
            },
            success: function(response) {
                console.log('Items loaded:', response); // Debug log

                let html = '';
                if (response && response.length > 0) {
                    response.forEach(function(item) {
                        const availableForTransfer = parseFloat(item.available_for_transfer || 0);

                        html += `
                            <tr data-item-id="${item.item_id}" data-inventory-id="${item.id}">
                                <td><strong>${item.item_code || 'N/A'}</strong></td>
                                <td>${item.item_name || 'N/A'}</td>
                                <td>
                                    <span class="badge badge-info">${availableForTransfer.toFixed(2)}</span>
                                </td>
                                <td>${item.unit || 'N/A'}</td>
                                <td>
                                    ${availableForTransfer > 0 ?
                                        `<button type="button" class="btn btn-allocate btn-sm" onclick="openAllocation(${item.item_id}, ${item.id})">
                                            <i class="material-icons" style="font-size: 14px;">assignment</i>
                                            Allocate
                                        </button>` :
                                        '<span class="text-muted">No stock</span>'
                                    }
                                </td>
                            </tr>
                        `;
                    });
                    $('#itemsCount').text(`(${response.length} items available)`);
                } else {
                    html = `
                        <tr>
                            <td colspan="6" class="items-empty">
                                <i class="material-icons mb-2" style="font-size: 48px;">inventory_2</i>
                                <div>No items found in this project</div>
                                <small class="text-muted">This project doesn't have any items with available stock for transfer.</small>
                            </td>
                        </tr>
                    `;
                    $('#itemsCount').text('(No items found)');
                }
                $('#items-tbody').html(html);
            },
            error: function(xhr, status, error) {
                console.error('Error loading items:', error, xhr.responseText); // Debug log
                $('#items-tbody').html(`
                    <tr>
                        <td colspan="6" class="text-center text-danger">
                            <i class="material-icons mb-2" style="font-size: 48px;">error</i>
                            <div>Error loading items</div>
                            <small>${error}</small>
                        </td>
                    </tr>
                `);
                $('#itemsCount').text('(Error loading)');
            }
        });
    }

    // Global function for opening allocation modal
    window.openAllocation = function(itemId, inventoryId) {
        const projectId = $('#from_project_id').val();

        $.ajax({
            url: '<?php echo e(route("warehouse.site-transfers.item-allocation")); ?>',
            method: 'GET',
            data: {
                project_id: projectId,
                item_id: itemId
            },
            beforeSend: function() {
                $('#allocationContent').html('<div class="text-center p-4"><div class="spinner-border"></div><div>Loading allocation details...</div></div>');
                $('#allocationModal').modal('show');
            },
            success: function(response) {
                showAllocationForm(response, itemId, inventoryId);
            },
            error: function() {
                $('#allocationContent').html('<div class="alert alert-danger">Error loading allocation details</div>');
            }
        });
    };

    function showAllocationForm(data, itemId, inventoryId) {
        let html = `
            <div class="item-info mb-4">
                <h6><strong>${data.item.name}</strong> (${data.item.code})</h6>
                <div class="row text-center">
                    <div class="col-md-3">
                        <div class="card bg-light">
                            <div class="card-body p-2">
                                <strong>${parseFloat(data.item.current_stock).toFixed(2)}</strong>
                                <small class="d-block text-muted">Total Stock</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-light">
                            <div class="card-body p-2">
                                <strong>${parseFloat(data.item.allocated_stock).toFixed(2)}</strong>
                                <small class="d-block text-muted">Allocated</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-success text-white">
                            <div class="card-body p-2">
                                <strong>${parseFloat(data.item.available_for_transfer).toFixed(2)}</strong>
                                <small class="d-block">Available</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-light">
                            <div class="card-body p-2">
                                <strong>${data.item.unit}</strong>
                                <small class="d-block text-muted">Unit</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <h6>Reference Allocations:</h6>
            <div id="allocationsContainer">
        `;

        if (data.allocations && data.allocations.length > 0) {
            data.allocations.forEach(function(allocation, index) {
                html += `
                    <div class="allocation-item mb-2 p-3 border rounded" data-allocation-id="${allocation.id}">
                        <div class="row align-items-center">
                            <div class="col-md-8">
                                <strong>Reference: ${allocation.reference}</strong>
                                <span class="badge badge-primary ml-2">${allocation.source_type || 'Stock'}</span>
                                <div class="small text-muted">
                                    Received: ${parseFloat(allocation.quantity_received).toFixed(2)} |
                                    Allocated: ${parseFloat(allocation.quantity_allocated).toFixed(2)} |
                                    Available: <span class="text-success">${parseFloat(allocation.quantity_available).toFixed(2)}</span>
                                </div>
                                <div class="small text-info">
                                    <i class="material-icons" style="font-size: 12px;">event</i>
                                    ${allocation.delivery_date}
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="input-group input-group-sm">
                                    <input type="number"
                                           class="form-control allocation-qty"
                                           data-allocation-id="${allocation.id}"
                                           max="${allocation.quantity_available}"
                                           min="0"
                                           step="0.01"
                                           placeholder="0.00">
                                    <div class="input-group-append">
                                        <span class="input-group-text">${data.item.unit}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                `;
            });
        } else {
            html += '<div class="alert alert-warning">No allocations found for this item.</div>';
        }

        html += `
            </div>
            <div class="mt-3">
                <div class="row">
                    <div class="col-md-6">
                        <strong>Total to Transfer: <span id="totalToTransfer">0.00</span> ${data.item.unit}</strong>
                    </div>
                    <div class="col-md-6 text-right">
                        <small class="text-muted">Available: ${parseFloat(data.item.available_for_transfer).toFixed(2)} ${data.item.unit}</small>
                    </div>
                </div>
            </div>
        `;

        $('#allocationContent').html(html);

        // Store current allocation data
        allocationData = {
            itemId: itemId,
            inventoryId: inventoryId,
            item: data.item,
            allocations: data.allocations || []
        };

        // Update total when quantities change
        $('.allocation-qty').on('input', function() {
            updateTotal();
        });
    }

    function updateTotal() {
        let total = 0;
        $('.allocation-qty').each(function() {
            const value = parseFloat($(this).val()) || 0;
            total += value;
        });
        $('#totalToTransfer').text(total.toFixed(2));
    }

    // Confirm allocation
    $('#confirmAllocation').on('click', function() {
        const allocations = [];
        let totalQty = 0;
        let isValid = true;

        $('.allocation-qty').each(function() {
            const qty = parseFloat($(this).val()) || 0;
            const allocationId = $(this).data('allocation-id');
            const maxQty = parseFloat($(this).attr('max'));

            if (qty > 0) {
                if (qty > maxQty) {
                    alert(`⚠️ Quantity Exceeds Available\n\nYou entered ${qty} but only ${maxQty} is available for this allocation.\n\nPlease adjust the quantity.`);
                    isValid = false;
                    return false;
                }
                allocations.push({
                    inventory_id: allocationId,
                    quantity: qty
                });
                totalQty += qty;
            }
        });

        if (!isValid) return;

        if (allocations.length === 0) {
            alert('⚠️ No Allocation Selected\n\nPlease allocate at least some quantity for this item before confirming.');
            return;
        }

        if (totalQty === 0) {
            alert('⚠️ Zero Quantity\n\nPlease enter a quantity greater than 0 for at least one allocation.');
            return;
        }

        // Add to selected items
        selectedItems[allocationData.itemId] = {
            project_inventory_id: allocationData.inventoryId,
            item_name: allocationData.item.name,
            item_code: allocationData.item.code,
            unit: allocationData.item.unit,
            quantity: totalQty,
            allocations: allocations
        };

        updateSelectedItemsDisplay();
        $('#allocationModal').modal('hide');
    });

    function updateSelectedItemsDisplay() {
        const count = Object.keys(selectedItems).length;

        if (count === 0) {
            $('#selectedItemsSection').hide();
            $('#submitBtn').prop('disabled', true);
            return;
        }

        $('#selectedItemsSection').show();
        $('#selectedItemsCount').text(count);
        $('#submitBtn').prop('disabled', false);

        let html = '';
        Object.entries(selectedItems).forEach(([itemId, item]) => {
            html += `
                <div class="item-row" data-item-id="${itemId}">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <strong>${item.item_code} - ${item.item_name}</strong>
                            <div class="small text-muted">
                                Quantity: <span class="allocation-badge">${parseFloat(item.quantity).toFixed(2)} ${item.unit}</span>
                            </div>
                        </div>
                        <div class="col-md-4 text-right">
                            <button type="button" class="btn btn-sm btn-outline-danger" onclick="removeSelectedItem('${itemId}')">
                                <i class="material-icons" style="font-size: 16px;">close</i>
                                Remove
                            </button>
                        </div>
                    </div>
                </div>
            `;
        });

        $('#selectedItemsList').html(html);
    }

    // Global function to remove selected item
    window.removeSelectedItem = function(itemId) {
        delete selectedItems[itemId];
        updateSelectedItemsDisplay();
    };

    function clearSelectedItems() {
        selectedItems = {};
        updateSelectedItemsDisplay();
    }

    // Form submission
    $('#siteTransferForm').on('submit', function(e) {
        e.preventDefault();

        if (Object.keys(selectedItems).length === 0) {
            console.error('No items selected for transfer');
            alert('⚠️ No Items Selected\n\nPlease select and allocate at least one item before submitting the transfer.\n\n1. Select source and destination projects\n2. Choose items from the available list\n3. Click "Allocate" to specify quantities\n4. Submit the transfer');
            return;
        }

        // Prepare form data
        const itemsInput = Object.entries(selectedItems).map(([itemId, item]) => {
            return {
                project_inventory_id: item.project_inventory_id,
                quantity: item.quantity,
                allocations: item.allocations
            };
        });

        const formData = new FormData(this);
        formData.set('items', JSON.stringify(itemsInput));

        console.log('Submitting site transfer form with data:', {
            from_project_id: formData.get('from_project_id'),
            to_project_id: formData.get('to_project_id'),
            transfer_date: formData.get('transfer_date'),
            notes: formData.get('notes'),
            items: itemsInput
        });

        // Get project names for confirmation
        const fromProjectName = $('#from_project_id option:selected').text();
        const toProjectName = $('#to_project_id option:selected').text();
        const itemCount = itemsInput.length;
        const totalItems = itemsInput.reduce((sum, item) => sum + parseFloat(item.quantity), 0);

        // Confirmation dialog
        const confirmMessage = `🚚 Confirm Site Transfer\n\n` +
            `FROM: ${fromProjectName}\n` +
            `TO: ${toProjectName}\n` +
            `ITEMS: ${itemCount} item(s)\n` +
            `TOTAL QUANTITY: ${totalItems.toFixed(2)}\n\n` +
            `Are you sure you want to proceed with this transfer?\n\n` +
            `This will immediately move materials from the source to destination project.`;

        if (!confirm(confirmMessage)) {
            return;
        }

        // Disable submit button during submission
        const submitBtn = $('#submitBtn');
        const originalText = submitBtn.html();
        submitBtn.prop('disabled', true).html('<i class="material-icons mr-1">hourglass_empty</i>Submitting...');

        // Submit via AJAX for better error handling
        $.ajax({
            url: $(this).attr('action'),
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                console.log('Site transfer submitted successfully:', response);

                // Show success message
                alert('✅ Transfer Completed Successfully!\n\nMaterials have been transferred from source to destination project.');

                // Redirect to index page
                setTimeout(() => {
                    window.location.href = '<?php echo e(route("warehouse.site-transfers.index")); ?>';
                }, 1000);
            },
            error: function(xhr, status, error) {
                console.error('Site transfer submission failed:', {
                    status: xhr.status,
                    statusText: xhr.statusText,
                    responseText: xhr.responseText,
                    error: error
                });

                let errorMessage = 'An error occurred while submitting the transfer.';

                if (xhr.status === 422) {
                    // Validation errors
                    try {
                        const response = JSON.parse(xhr.responseText);
                        if (response.errors) {
                            errorMessage = 'Please fix the following validation errors:\n\n';
                            Object.keys(response.errors).forEach(field => {
                                const fieldName = field.replace(/[\[\]\.]/g, ' ').replace(/\s+/g, ' ').trim();
                                errorMessage += `• ${fieldName}: ${response.errors[field].join(', ')}\n`;
                            });
                        }
                    } catch (e) {
                        errorMessage = 'Validation failed. Please check your inputs.';
                    }
                } else if (xhr.status === 500) {
                    errorMessage = 'A server error occurred. Please try again or contact support.';
                } else if (xhr.status === 0) {
                    errorMessage = 'Network error. Please check your connection.';
                } else {
                    errorMessage = `Error ${xhr.status}: ${xhr.statusText || 'Unknown error occurred'}`;
                }

                // Show error in both console and user-friendly alert
                console.error('Detailed error info:', xhr.responseText);
                alert('❌ Transfer Failed\n\n' + errorMessage);
                console.error('Full error response:', xhr);
            },
            complete: function() {
                // Re-enable submit button
                submitBtn.prop('disabled', false).html(originalText);
            }
        });
    });

    // Form validation
    $('#from_project_id, #to_project_id').on('change', function() {
        const fromProject = $('#from_project_id').val();
        const toProject = $('#to_project_id').val();

        if (fromProject && toProject && fromProject === toProject) {
            alert('Source and destination projects cannot be the same');
            $(this).val('').trigger('change');
        }
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/site-transfers/create.blade.php ENDPATH**/ ?>