<!-- View User Modal -->
<div class="modal fade" id="viewUserModal<?php echo e($user->id); ?>" tabindex="-1" role="dialog" aria-labelledby="viewUserModalLabel<?php echo e($user->id); ?>" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="viewUserModalLabel<?php echo e($user->id); ?>">User Details</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-4 text-center mb-4">
                        <img src="<?php echo e($user->avatar_url); ?>" alt="<?php echo e($user->full_name); ?>" class="rounded-circle mb-3" style="width: 120px; height: 120px; object-fit: cover;">
                        <h5><?php echo e($user->full_name); ?></h5>
                        <?php if($user->role): ?>
                            <span class="badge badge-soft-info"><?php echo e($user->role->display_name); ?></span>
                        <?php endif; ?>
                        <br>
                        <?php
                            $statusClass = match($user->status) {
                                'active' => 'badge-soft-success',
                                'inactive' => 'badge-soft-warning', 
                                'suspended' => 'badge-soft-danger',
                                default => 'badge-soft-secondary'
                            };
                        ?>
                        <span class="badge <?php echo e($statusClass); ?> mt-2"><?php echo e(ucfirst($user->status)); ?></span>
                        <?php if($user->first_login): ?>
                            <br><span class="badge badge-soft-info mt-1">Awaiting First Login</span>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-8">
                        <div class="row">
                            <div class="col-md-6">
                                <h6>Personal Information</h6>
                                <table class="table table-sm table-borderless">
                                    <tr>
                                        <td><strong>First Name:</strong></td>
                                        <td><?php echo e($user->first_name); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Last Name:</strong></td>
                                        <td><?php echo e($user->last_name); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Email:</strong></td>
                                        <td><?php echo e($user->email); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Phone:</strong></td>
                                        <td><?php echo e($user->phone ?? 'N/A'); ?></td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <h6>Work Information</h6>
                                <table class="table table-sm table-borderless">
                                    <tr>
                                        <td><strong>Employee ID:</strong></td>
                                        <td><?php echo e($user->employee_id ?? 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Department:</strong></td>
                                        <td><?php echo e($user->department ?? 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Role:</strong></td>
                                        <td><?php echo e($user->role->display_name ?? 'No Role'); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Status:</strong></td>
                                        <td><?php echo e(ucfirst($user->status)); ?></td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                        
                        <hr>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <h6>Account Information</h6>
                                <table class="table table-sm table-borderless">
                                    <tr>
                                        <td><strong>Created:</strong></td>
                                        <td><?php echo e($user->created_at->format('M d, Y H:i')); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Last Login:</strong></td>
                                        <td><?php echo e($user->last_login_at ? $user->last_login_at->format('M d, Y H:i') : 'Never'); ?></td>
                                    </tr>
                                    <?php if($user->createdByAdmin): ?>
                                    <tr>
                                        <td><strong>Created By:</strong></td>
                                        <td><?php echo e($user->createdByAdmin->full_name); ?></td>
                                    </tr>
                                    <?php endif; ?>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <?php if($user->role && $user->role->permissions->count() > 0): ?>
                                <h6>Permissions</h6>
                                <div class="permissions-list" style="max-height: 150px; overflow-y: auto;">
                                    <?php $__currentLoopData = $user->role->permissions->groupBy('group'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group => $permissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="mb-2">
                                            <small class="text-muted text-uppercase font-weight-bold"><?php echo e(ucfirst($group)); ?></small>
                                            <br>
                                            <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <span class="badge badge-light badge-sm mr-1 mb-1"><?php echo e($permission->display_name); ?></span>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <?php if(auth()->user()->hasPermission('edit_users')): ?>
                    <button type="button" class="btn btn-primary" data-dismiss="modal" data-toggle="modal" data-target="#editUserModal<?php echo e($user->id); ?>">
                        <i class="material-icons mr-2">edit</i> Edit User
                    </button>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/admin/users/modals/view.blade.php ENDPATH**/ ?>