<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Material Issue Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            font-size: 18px;
            color: #333;
        }
        .header .subtitle {
            margin: 5px 0 0 0;
            color: #666;
            font-size: 12px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: left;
            vertical-align: top;
        }
        th {
            background-color: #f8f9fa;
            font-weight: bold;
            font-size: 10px;
        }
        td {
            font-size: 9px;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .type-success {
            background-color: #d4edda;
            color: #155724;
            padding: 2px 5px;
            border-radius: 3px;
        }
        .type-info {
            background-color: #cce5ff;
            color: #004085;
            padding: 2px 5px;
            border-radius: 3px;
        }
        .type-warning {
            background-color: #fff3cd;
            color: #856404;
            padding: 2px 5px;
            border-radius: 3px;
        }
        .type-primary {
            background-color: #cce5ff;
            color: #004085;
            padding: 2px 5px;
            border-radius: 3px;
        }
        .status-success {
            background-color: #d4edda;
            color: #155724;
            padding: 2px 5px;
            border-radius: 3px;
        }
        .status-warning {
            background-color: #fff3cd;
            color: #856404;
            padding: 2px 5px;
            border-radius: 3px;
        }
        .status-danger {
            background-color: #f8d7da;
            color: #721c24;
            padding: 2px 5px;
            border-radius: 3px;
        }
        .status-info {
            background-color: #cce5ff;
            color: #004085;
            padding: 2px 5px;
            border-radius: 3px;
        }
        .status-secondary {
            background-color: #e9ecef;
            color: #495057;
            padding: 2px 5px;
            border-radius: 3px;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
        .summary {
            margin-bottom: 20px;
            padding: 10px;
            background-color: #e9ecef;
            border-radius: 5px;
        }
        .summary-grid {
            width: 100%;
        }
        .summary-grid td {
            border: none;
            text-align: center;
            width: 20%;
        }
        .summary-label {
            font-size: 10px;
            color: #666;
            margin-bottom: 2px;
        }
        .summary-value {
            font-size: 14px;
            font-weight: bold;
            color: #333;
        }
        .no-print {
            margin-bottom: 20px;
            text-align: center;
        }
        .no-print button {
            padding: 10px 20px;
            font-size: 14px;
            cursor: pointer;
            margin: 0 5px;
        }
        .btn-print {
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 4px;
        }
        .btn-back {
            background-color: #6c757d;
            color: white;
            border: none;
            border-radius: 4px;
        }
        @media print {
            .no-print {
                display: none;
            }
            body {
                padding: 0;
            }
            @page {
                size: landscape;
                margin: 10mm;
            }
        }
    </style>
</head>
<body>
    <div class="no-print">
        <button class="btn-print" onclick="window.print()">Print / Save as PDF</button>
        <button class="btn-back" onclick="window.history.back()">Back to Report</button>
    </div>

    <div class="header">
        <h1>Material Issue Report</h1>
        <p class="subtitle">Generated on <?php echo e($generated_at); ?></p>
    </div>

    <div class="summary">
        <table class="summary-grid">
            <tr>
                <td>
                    <div class="summary-label">Total Transactions</div>
                    <div class="summary-value"><?php echo e(number_format($stats['total'])); ?></div>
                </td>
                <td>
                    <div class="summary-label">Incoming Operations</div>
                    <div class="summary-value"><?php echo e(number_format($stats['incoming'])); ?></div>
                </td>
                <td>
                    <div class="summary-label">Outgoing</div>
                    <div class="summary-value"><?php echo e(number_format($stats['outgoing'])); ?></div>
                </td>
                <td>
                    <div class="summary-label">Direct Deliveries</div>
                    <div class="summary-value"><?php echo e(number_format($stats['direct_deliveries'])); ?></div>
                </td>
                <td>
                    <div class="summary-label">Transfers</div>
                    <div class="summary-value"><?php echo e(number_format($stats['transfers'])); ?></div>
                </td>
            </tr>
        </table>
    </div>

    <table>
        <thead>
            <tr>
                <th style="width: 14%;">Transaction ID</th>
                <th style="width: 10%;">Date</th>
                <th style="width: 12%;">Type</th>
                <th style="width: 12%;">Reference</th>
                <th style="width: 16%;">Entity/Supplier</th>
                <th style="width: 16%;">Project</th>
                <th style="width: 10%;" class="text-center">Status</th>
                <th style="width: 10%;">Created By</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($transaction['id'] ?? '-'); ?></td>
                    <td><?php echo e($transaction['date'] ? \Carbon\Carbon::parse($transaction['date'])->format('d M Y') : '-'); ?></td>
                    <td>
                        <span class="type-<?php echo e($transaction['type_badge'] ?? 'secondary'); ?>">
                            <?php echo e($transaction['type'] ?? '-'); ?>

                        </span>
                    </td>
                    <td><?php echo e($transaction['reference'] ?? '-'); ?></td>
                    <td><?php echo e(Str::limit($transaction['entity'] ?? '-', 20)); ?></td>
                    <td><?php echo e(Str::limit($transaction['project'] ?? '-', 20)); ?></td>
                    <td class="text-center">
                        <span class="status-<?php echo e($transaction['status_badge'] ?? 'secondary'); ?>">
                            <?php echo e($transaction['status'] ?? '-'); ?>

                        </span>
                    </td>
                    <td><?php echo e(Str::limit($transaction['created_by'] ?? '-', 15)); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="8" class="text-center">No transactions found</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div class="footer">
        <p>KCG Inventory Management System - Material Issue Report</p>
        <p>This report contains <?php echo e(number_format($stats['total'])); ?> transactions</p>
    </div>
</body>
</html>
<?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/reports/pdf/transactions.blade.php ENDPATH**/ ?>