<!-- Edit User Modal -->
<div class="modal fade" id="editUserModal<?php echo e($user->id); ?>" tabindex="-1" role="dialog" aria-labelledby="editUserModalLabel<?php echo e($user->id); ?>" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editUserModalLabel<?php echo e($user->id); ?>">Edit User: <?php echo e($user->full_name); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="editUserForm<?php echo e($user->id); ?>" data-user-id="<?php echo e($user->id); ?>">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_first_name<?php echo e($user->id); ?>">First Name *</label>
                                <input type="text" class="form-control" id="edit_first_name<?php echo e($user->id); ?>" name="first_name" value="<?php echo e($user->first_name); ?>" required>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_last_name<?php echo e($user->id); ?>">Last Name *</label>
                                <input type="text" class="form-control" id="edit_last_name<?php echo e($user->id); ?>" name="last_name" value="<?php echo e($user->last_name); ?>" required>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_email<?php echo e($user->id); ?>">Email Address *</label>
                                <input type="email" class="form-control" id="edit_email<?php echo e($user->id); ?>" name="email" value="<?php echo e($user->email); ?>" required>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_phone<?php echo e($user->id); ?>">Phone Number</label>
                                <input type="text" class="form-control" id="edit_phone<?php echo e($user->id); ?>" name="phone" value="<?php echo e($user->phone); ?>">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_employee_id<?php echo e($user->id); ?>">Employee ID</label>
                                <input type="text" class="form-control" id="edit_employee_id<?php echo e($user->id); ?>" name="employee_id" value="<?php echo e($user->employee_id); ?>">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_role_id<?php echo e($user->id); ?>">Role *</label>
                                <select class="form-control" id="edit_role_id<?php echo e($user->id); ?>" name="role_id" required>
                                    <option value="">Select Role</option>
                                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($role->id); ?>" <?php echo e($user->role_id == $role->id ? 'selected' : ''); ?>>
                                            <?php echo e($role->display_name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_status<?php echo e($user->id); ?>">Status *</label>
                                <select class="form-control" id="edit_status<?php echo e($user->id); ?>" name="status" required>
                                    <option value="active" <?php echo e($user->status == 'active' ? 'selected' : ''); ?>>Active</option>
                                    <option value="inactive" <?php echo e($user->status == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                                    <option value="suspended" <?php echo e($user->status == 'suspended' ? 'selected' : ''); ?>>Suspended</option>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>
                    
                    <?php if($user->first_login): ?>
                    <div class="alert alert-info">
                        <i class="material-icons mr-2">info</i>
                        This user has not completed their first login yet.
                    </div>
                    <?php endif; ?>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="material-icons mr-2">save</i>
                        Update User
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.getElementById('editUserForm<?php echo e($user->id); ?>').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const form = this;
    const userId = form.dataset.userId;
    const submitBtn = form.querySelector('button[type="submit"]');
    const originalText = submitBtn.innerHTML;
    
    // Clear previous errors
    form.querySelectorAll('.is-invalid').forEach(el => el.classList.remove('is-invalid'));
    form.querySelectorAll('.invalid-feedback').forEach(el => el.textContent = '');
    
    // Show loading state
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<i class="material-icons mr-2">hourglass_empty</i> Updating...';
    
    // Submit form
    fetch(`/admin/users/${userId}`, {
        method: 'PUT',
        body: new FormData(form),
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToastMessage(data.message, 'success');
            
            // Close modal and reload page
            $('#editUserModal<?php echo e($user->id); ?>').modal('hide');
            setTimeout(() => location.reload(), 1000);
        } else {
            // Handle validation errors
            if (data.errors) {
                Object.keys(data.errors).forEach(field => {
                    const input = form.querySelector(`[name="${field}"]`);
                    if (input) {
                        input.classList.add('is-invalid');
                        const feedback = input.nextElementSibling;
                        if (feedback && feedback.classList.contains('invalid-feedback')) {
                            feedback.textContent = data.errors[field][0];
                        }
                    }
                });
            } else {
                showToastMessage(data.message || 'An error occurred', 'error');
            }
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToastMessage('An error occurred while updating the user', 'error');
    })
    .finally(() => {
        submitBtn.disabled = false;
        submitBtn.innerHTML = originalText;
    });
});
</script><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/admin/users/modals/edit.blade.php ENDPATH**/ ?>