@extends('layouts.admin-simple')

@section('title', 'Edit Supplier')
@section('page-title', 'Edit Supplier')
@section('page-subtitle', 'Update supplier information')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('warehouse.suppliers.index') }}">Suppliers</a></li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.suppliers.show', $supplier) }}">{{ $supplier->name }}</a></li>
    <li class="breadcrumb-item active">Edit</li>
@endsection

@section('content')
<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex justify-content-between align-items-center">
        <h6 class="m-0 font-weight-bold text-primary">Edit Supplier Information</h6>
        <span class="text-muted">{{ $supplier->supplier_code }}</span>
    </div>

    <div class="card-body">
        <form action="{{ route('warehouse.suppliers.update', $supplier) }}" method="POST">
            @csrf
            @method('PUT')

            <!-- Basic Information -->
            <div class="mb-4">
                <h6 class="text-primary font-weight-bold mb-3">Basic Information</h6>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="name" class="form-label">Name <span class="text-danger">*</span></label>
                        <input type="text" name="name" id="name" required
                               class="form-control @error('name') is-invalid @enderror"
                               value="{{ old('name', $supplier->name) }}">
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="supplier_code" class="form-label">Supplier Code</label>
                        <input type="text" name="supplier_code" id="supplier_code"
                               class="form-control @error('supplier_code') is-invalid @enderror"
                               value="{{ old('supplier_code', $supplier->supplier_code) }}"
                               @if($supplier->incomingTransactions()->exists()) readonly title="Cannot change supplier code for suppliers with existing transactions" @endif>
                        @error('supplier_code')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        @if($supplier->incomingTransactions()->exists())
                            <small class="text-warning">Supplier code cannot be changed due to existing transactions.</small>
                        @endif
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="contact_person" class="form-label">Contact Person</label>
                        <input type="text" name="contact_person" id="contact_person"
                               class="form-control @error('contact_person') is-invalid @enderror"
                               value="{{ old('contact_person', $supplier->contact_person) }}">
                        @error('contact_person')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <x-warehouse.select2-dropdown
                        name="status"
                        id="status"
                        label="Status"
                        placeholder="Select status"
                        :options="[
                            ['value' => 'active', 'text' => 'Active'],
                            ['value' => 'inactive', 'text' => 'Inactive'],
                            ['value' => 'suspended', 'text' => 'Suspended']
                        ]"
                        :selected="old('status', $supplier->status)"
                        required="true"
                    />
                </div>
            </div>

            <!-- Contact Information -->
            <div class="mb-4 mt-4">
                <h6 class="text-primary font-weight-bold mb-3">Contact Information</h6>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="email" class="form-label">Email</label>
                        <input type="email" name="email" id="email"
                               class="form-control @error('email') is-invalid @enderror"
                               value="{{ old('email', $supplier->email) }}">
                        @error('email')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="phone" class="form-label">Phone</label>
                        <input type="text" name="phone" id="phone"
                               class="form-control @error('phone') is-invalid @enderror"
                               value="{{ old('phone', $supplier->phone) }}">
                        @error('phone')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="mobile" class="form-label">Mobile</label>
                        <input type="text" name="mobile" id="mobile"
                               class="form-control @error('mobile') is-invalid @enderror"
                               value="{{ old('mobile', $supplier->mobile) }}">
                        @error('mobile')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="website" class="form-label">Website</label>
                        <input type="url" name="website" id="website"
                               class="form-control @error('website') is-invalid @enderror"
                               value="{{ old('website', $supplier->website) }}">
                        @error('website')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Address Information -->
            <div class="mb-4 mt-4">
                <h6 class="text-primary font-weight-bold mb-3">Address Information</h6>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label for="address" class="form-label">Address</label>
                        <textarea name="address" id="address" rows="3"
                                  class="form-control @error('address') is-invalid @enderror">{{ old('address', $supplier->address) }}</textarea>
                        @error('address')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="city" class="form-label">City</label>
                        <input type="text" name="city" id="city"
                               class="form-control @error('city') is-invalid @enderror"
                               value="{{ old('city', $supplier->city) }}">
                        @error('city')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="state" class="form-label">State</label>
                        <input type="text" name="state" id="state"
                               class="form-control @error('state') is-invalid @enderror"
                               value="{{ old('state', $supplier->state) }}">
                        @error('state')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="country" class="form-label">Country</label>
                        <input type="text" name="country" id="country"
                               class="form-control @error('country') is-invalid @enderror"
                               value="{{ old('country', $supplier->country) }}">
                        @error('country')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="postal_code" class="form-label">Postal Code</label>
                        <input type="text" name="postal_code" id="postal_code"
                               class="form-control @error('postal_code') is-invalid @enderror"
                               value="{{ old('postal_code', $supplier->postal_code) }}">
                        @error('postal_code')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Financial Information -->
            <div class="mb-4 mt-4">
                <h6 class="text-primary font-weight-bold mb-3">Financial Information</h6>
            </div>

            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="payment_terms" class="form-label">Payment Terms</label>
                        <input type="text" name="payment_terms" id="payment_terms"
                               class="form-control @error('payment_terms') is-invalid @enderror"
                               value="{{ old('payment_terms', $supplier->payment_terms) }}">
                        @error('payment_terms')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="credit_limit" class="form-label">Credit Limit</label>
                        <input type="number" name="credit_limit" id="credit_limit" min="0" step="0.01"
                               class="form-control @error('credit_limit') is-invalid @enderror"
                               value="{{ old('credit_limit', $supplier->credit_limit) }}">
                        @error('credit_limit')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <x-warehouse.select2-dropdown
                        name="currency"
                        id="currency"
                        label="Currency"
                        placeholder="Select currency"
                        :options="[
                            ['value' => 'AED', 'text' => 'AED - UAE Dirham'],
                            ['value' => 'USD', 'text' => 'USD - US Dollar'],
                            ['value' => 'EUR', 'text' => 'EUR - Euro'],
                            ['value' => 'GBP', 'text' => 'GBP - British Pound'],
                            ['value' => 'JPY', 'text' => 'JPY - Japanese Yen'],
                            ['value' => 'SAR', 'text' => 'SAR - Saudi Riyal'],
                            ['value' => 'CAD', 'text' => 'CAD - Canadian Dollar'],
                            ['value' => 'AUD', 'text' => 'AUD - Australian Dollar']
                        ]"
                        :selected="old('currency', $supplier->currency)"
                        allowClear="true"
                    />
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="tax_number" class="form-label">Tax Number</label>
                        <input type="text" name="tax_number" id="tax_number"
                               class="form-control @error('tax_number') is-invalid @enderror"
                               value="{{ old('tax_number', $supplier->tax_number) }}">
                        @error('tax_number')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Banking Information -->
            <div class="mb-4 mt-4">
                <h6 class="text-primary font-weight-bold mb-3">Banking Information</h6>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="bank_name" class="form-label">Bank Name</label>
                        <input type="text" name="bank_name" id="bank_name"
                               class="form-control @error('bank_name') is-invalid @enderror"
                               value="{{ old('bank_name', $supplier->bank_name) }}">
                        @error('bank_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="bank_account" class="form-label">Bank Account</label>
                        <input type="text" name="bank_account" id="bank_account"
                               class="form-control @error('bank_account') is-invalid @enderror"
                               value="{{ old('bank_account', $supplier->bank_account) }}">
                        @error('bank_account')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Additional Information -->
            <div class="mb-4 mt-4">
                <h6 class="text-primary font-weight-bold mb-3">Additional Information</h6>
            </div>

            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="rating" class="form-label">Rating (0-5)</label>
                        <input type="number" name="rating" id="rating" min="0" max="5" step="0.1"
                               class="form-control @error('rating') is-invalid @enderror"
                               value="{{ old('rating', $supplier->rating) }}">
                        @error('rating')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-9">
                    <div class="form-group">
                        <label for="notes" class="form-label">Notes</label>
                        <textarea name="notes" id="notes" rows="4"
                                  class="form-control @error('notes') is-invalid @enderror">{{ old('notes', $supplier->notes) }}</textarea>
                        @error('notes')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="d-flex justify-content-between mt-4 pt-3 border-top">
                <a href="{{ route('warehouse.suppliers.show', $supplier) }}" class="btn btn-secondary">
                    <i class="material-icons mr-1" style="font-size: 16px;">cancel</i>
                    Cancel
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="material-icons mr-1" style="font-size: 16px;">save</i>
                    Update Supplier
                </button>
            </div>
        </form>
    </div>
</div>
@endsection