<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Materials Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            font-size: 18px;
            color: #333;
        }
        .header .subtitle {
            margin: 5px 0 0 0;
            color: #666;
            font-size: 12px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: left;
            vertical-align: top;
        }
        th {
            background-color: #f8f9fa;
            font-weight: bold;
            font-size: 10px;
        }
        td {
            font-size: 9px;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .status-in_stock {
            background-color: #d4edda;
            color: #155724;
            padding: 2px 5px;
            border-radius: 3px;
        }
        .status-low_stock {
            background-color: #fff3cd;
            color: #856404;
            padding: 2px 5px;
            border-radius: 3px;
        }
        .status-out_of_stock {
            background-color: #f8d7da;
            color: #721c24;
            padding: 2px 5px;
            border-radius: 3px;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
        .summary {
            margin-bottom: 20px;
            padding: 10px;
            background-color: #e9ecef;
            border-radius: 5px;
        }
        .summary-grid {
            width: 100%;
        }
        .summary-grid td {
            border: none;
            text-align: center;
            width: 33%;
        }
        .summary-label {
            font-size: 10px;
            color: #666;
            margin-bottom: 2px;
        }
        .summary-value {
            font-size: 14px;
            font-weight: bold;
            color: #333;
        }
        .no-print {
            margin-bottom: 20px;
            text-align: center;
        }
        .no-print button {
            padding: 10px 20px;
            font-size: 14px;
            cursor: pointer;
            margin: 0 5px;
        }
        .btn-print {
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 4px;
        }
        .btn-back {
            background-color: #6c757d;
            color: white;
            border: none;
            border-radius: 4px;
        }
        @media print {
            .no-print {
                display: none;
            }
            body {
                padding: 0;
            }
            @page {
                size: landscape;
                margin: 10mm;
            }
        }
    </style>
</head>
<body>
    <div class="no-print">
        <button class="btn-print" onclick="window.print()">Print / Save as PDF</button>
        <button class="btn-back" onclick="window.history.back()">Back to Report</button>
    </div>

    <div class="header">
        <h1>Materials Report</h1>
        <p class="subtitle">Generated on {{ $generated_at }}</p>
    </div>

    <div class="summary">
        <table class="summary-grid">
            <tr>
                <td>
                    <div class="summary-label">Total Materials</div>
                    <div class="summary-value">{{ number_format($items->count()) }}</div>
                </td>
                <td>
                    <div class="summary-label">Total Quantity</div>
                    <div class="summary-value">{{ number_format($total_quantity, 2) }}</div>
                </td>
                <td>
                    <div class="summary-label">Total Value</div>
                    <div class="summary-value">AED {{ number_format($total_value, 2) }}</div>
                </td>
            </tr>
        </table>
    </div>

    <table>
        <thead>
            <tr>
                <th style="width: 12%;">Material Code</th>
                <th style="width: 25%;">Description</th>
                <th style="width: 10%;">Category</th>
                <th style="width: 6%;">Unit</th>
                <th style="width: 8%;" class="text-right">Quantity</th>
                <th style="width: 10%;" class="text-right">Avg Price</th>
                <th style="width: 10%;" class="text-right">Price Range</th>
                <th style="width: 10%;" class="text-right">Total Value</th>
                <th style="width: 9%;" class="text-center">Status</th>
            </tr>
        </thead>
        <tbody>
            @forelse($items as $item)
                <tr>
                    <td>{{ $item->item_code }}</td>
                    <td>{{ Str::limit($item->item_description, 40) }}</td>
                    <td>{{ $item->category }}</td>
                    <td>{{ $item->unit_of_measure }}</td>
                    <td class="text-right">{{ number_format($item->total_quantity, 2) }}</td>
                    <td class="text-right">{{ number_format($item->average_unit_price, 2) }}</td>
                    <td class="text-right">
                        @if($item->min_price > 0 && $item->max_price > 0)
                            {{ number_format($item->min_price, 2) }} - {{ number_format($item->max_price, 2) }}
                        @else
                            -
                        @endif
                    </td>
                    <td class="text-right">{{ number_format($item->total_value, 2) }}</td>
                    <td class="text-center">
                        <span class="status-{{ $item->overall_status }}">
                            {{ ucfirst(str_replace('_', ' ', $item->overall_status)) }}
                        </span>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="9" class="text-center">No materials found</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="footer">
        <p>KCG Inventory Management System - Materials Report</p>
        <p>This report contains {{ number_format($items->count()) }} materials with a total value of AED {{ number_format($total_value, 2) }}</p>
    </div>
</body>
</html>
