@extends('layouts.admin-simple')

@section('title', 'Incoming Item Details - ' . $itemDetails->item_code)

@section('breadcrumb')
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.reports.index') }}">Reports</a></li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.reports.incoming') }}">Incoming Materials</a></li>
    <li class="breadcrumb-item active">{{ $itemDetails->item_code }}</li>
@endsection

@section('page-title')
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">{{ $itemDetails->item_code }} - Delivery Details</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">{{ $itemDetails->item_description }}</p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <a href="{{ route('warehouse.reports.incoming') }}" class="btn btn-sm btn-outline-secondary mr-2">
                <i class="material-icons mr-1" style="font-size: 16px;">arrow_back</i>
                Back to Report
            </a>
            <button type="button" onclick="printItemDetails()" class="btn btn-sm btn-info">
                <i class="material-icons mr-1" style="font-size: 16px;">print</i>
                Print Details
            </button>
        </div>
    </div>
@endsection

@section('content')
    <!-- Operation Summary -->
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">local_shipping</i>
                Operation Information
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Operation #:</strong></td>
                            <td><span class="badge badge-primary">{{ $operationDetails->operation_number }}</span></td>
                        </tr>
                        <tr>
                            <td><strong>Operation Type:</strong></td>
                            <td>
                                <span class="badge badge-outline-info">{{ ucfirst(str_replace('_', ' ', $operationDetails->operation_type)) }}</span>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Operation Date:</strong></td>
                            <td>{{ $operationDetails->operation_date ? $operationDetails->operation_date->format('d M, Y') : '-' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Status:</strong></td>
                            <td>
                                <span class="badge badge-{{
                                    $operationDetails->status === 'completed' ? 'success' :
                                    ($operationDetails->status === 'approved' ? 'info' :
                                    ($operationDetails->status === 'pending' ? 'warning' : 'secondary'))
                                }}">
                                    {{ ucfirst(str_replace('_', ' ', $operationDetails->status)) }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>LPO Number:</strong></td>
                            <td><span class="badge badge-outline-primary">{{ $operationDetails->lpo_number ?: 'N/A' }}</span></td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Supplier:</strong></td>
                            <td>
                                <div>{{ $operationDetails->supplier_name }}</div>
                                <small class="text-muted">Code: {{ $operationDetails->supplier_code }}</small>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Division:</strong></td>
                            <td><span class="badge badge-light">{{ $operationDetails->division }}</span></td>
                        </tr>
                        <tr>
                            <td><strong>Delivery Note:</strong></td>
                            <td>{{ $operationDetails->delivery_note_number ?: '-' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Received By:</strong></td>
                            <td>{{ $operationDetails->received_by }}</td>
                        </tr>
                        <tr>
                            <td><strong>Total Amount:</strong></td>
                            <td><strong>AED {{ number_format($operationDetails->total_amount, 2) }}</strong></td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Item Details & Quantities -->
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">inventory_2</i>
                Item Details & Quantities
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Item Code:</strong></td>
                            <td><code>{{ $itemDetails->item_code }}</code></td>
                        </tr>
                        <tr>
                            <td><strong>Description:</strong></td>
                            <td>{{ $itemDetails->item_description }}</td>
                        </tr>
                        <tr>
                            <td><strong>Category:</strong></td>
                            <td><span class="badge badge-outline-primary">{{ $itemDetails->category_name }}</span></td>
                        </tr>
                        <tr>
                            <td><strong>Unit of Measure:</strong></td>
                            <td>{{ $itemDetails->unit_of_measure }}</td>
                        </tr>
                        <tr>
                            <td><strong>Manufacturer:</strong></td>
                            <td>{{ $itemDetails->manufacturer ?: '-' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Country of Origin:</strong></td>
                            <td>{{ $itemDetails->country_of_origin ?: '-' }}</td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Quantity Ordered:</strong></td>
                            <td><span class="text-info">{{ number_format($itemDetails->quantity_ordered, 2) }} {{ $itemDetails->unit_of_measure }}</span></td>
                        </tr>
                        <tr>
                            <td><strong>Quantity Delivered:</strong></td>
                            <td><strong class="text-primary">{{ number_format($itemDetails->quantity_delivered, 2) }} {{ $itemDetails->unit_of_measure }}</strong></td>
                        </tr>
                        <tr>
                            <td><strong>Quantity Accepted:</strong></td>
                            <td><strong class="text-success">{{ number_format($itemDetails->quantity_accepted, 2) }} {{ $itemDetails->unit_of_measure }}</strong></td>
                        </tr>
                        <tr>
                            <td><strong>Quantity Rejected:</strong></td>
                            <td><strong class="text-danger">{{ number_format($itemDetails->quantity_rejected, 2) }} {{ $itemDetails->unit_of_measure }}</strong></td>
                        </tr>
                        <tr>
                            <td><strong>Unit Price:</strong></td>
                            <td>
                                <div>{{ $itemDetails->currency }} {{ number_format($itemDetails->unit_price, 2) }}</div>
                                <small class="text-muted">AED {{ number_format($itemDetails->unit_price_aed, 2) }}</small>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Total Price:</strong></td>
                            <td><strong>AED {{ number_format($itemDetails->total_price_aed, 2) }}</strong></td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Quality & Batch Information -->
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">verified</i>
                Quality Control & Batch Information
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Quality Status:</strong></td>
                            <td>
                                <span class="badge badge-{{
                                    $itemDetails->quality_status === 'passed' ? 'success' :
                                    ($itemDetails->quality_status === 'failed' ? 'danger' :
                                    ($itemDetails->quality_status === 'pending' ? 'warning' : 'info'))
                                }}">
                                    {{ ucfirst($itemDetails->quality_status ?: 'Not inspected') }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Acceptance Rate:</strong></td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="progress flex-grow-1 mr-2" style="height: 20px;">
                                        <div class="progress-bar bg-success" style="width: {{ $itemDetails->acceptance_rate }}%">
                                            {{ round($itemDetails->acceptance_rate, 1) }}%
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Batch Number:</strong></td>
                            <td><code>{{ $itemDetails->batch_number ?: 'N/A' }}</code></td>
                        </tr>
                        <tr>
                            <td><strong>Serial Number:</strong></td>
                            <td><code>{{ $itemDetails->serial_number ?: 'N/A' }}</code></td>
                        </tr>
                        <tr>
                            <td><strong>Storage Location:</strong></td>
                            <td>{{ $itemDetails->storage_location ?: '-' }}</td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Production Date:</strong></td>
                            <td>{{ $itemDetails->production_date ? $itemDetails->production_date->format('d M, Y') : '-' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Expiry Date:</strong></td>
                            <td>
                                @if($itemDetails->expiry_date)
                                    <span class="{{ $itemDetails->days_until_expiry !== null && $itemDetails->days_until_expiry < 0 ? 'text-danger' : ($itemDetails->days_until_expiry !== null && $itemDetails->days_until_expiry <= 30 ? 'text-warning' : 'text-success') }}">
                                        {{ $itemDetails->expiry_date->format('d M, Y') }}
                                    </span>
                                @else
                                    -
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Days to Expiry:</strong></td>
                            <td>
                                @if($itemDetails->days_until_expiry !== null)
                                    @if($itemDetails->days_until_expiry < 0)
                                        <span class="text-danger font-weight-bold">Expired ({{ abs($itemDetails->days_until_expiry) }} days ago)</span>
                                    @elseif($itemDetails->days_until_expiry <= 30)
                                        <span class="text-warning font-weight-bold">{{ $itemDetails->days_until_expiry }} days</span>
                                    @else
                                        <span class="text-success">{{ $itemDetails->days_until_expiry }} days</span>
                                    @endif
                                @else
                                    -
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Hazardous Material:</strong></td>
                            <td>
                                @if($itemDetails->hazardous_material)
                                    <span class="badge badge-danger">Yes</span>
                                @else
                                    <span class="badge badge-success">No</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Warranty Period:</strong></td>
                            <td>{{ $itemDetails->warranty_period_months ? $itemDetails->warranty_period_months . ' months' : '-' }}</td>
                        </tr>
                    </table>
                </div>
            </div>

            @if($itemDetails->quality_notes)
                <div class="row mt-3">
                    <div class="col-12">
                        <strong>Quality Notes:</strong>
                        <div class="mt-1 p-2 bg-light rounded">
                            {{ $itemDetails->quality_notes }}
                        </div>
                    </div>
                </div>
            @endif

            @if($itemDetails->rejection_reason)
                <div class="row mt-3">
                    <div class="col-12">
                        <strong>Rejection Reason:</strong>
                        <div class="mt-1 p-2 bg-danger text-white rounded">
                            {{ $itemDetails->rejection_reason }}
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>

    <!-- Inspection & Approval -->
    <div class="row">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="material-icons mr-2">fact_check</i>
                        Inspection Details
                    </h6>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        <div class="list-group-item d-flex justify-content-between px-0">
                            <span>Inspector:</span>
                            <span>{{ $operationDetails->inspector }}</span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between px-0">
                            <span>Inspection Date:</span>
                            <span>{{ $operationDetails->inspection_datetime ? $operationDetails->inspection_datetime->format('d M, Y H:i') : 'Not inspected' }}</span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between px-0">
                            <span>Inspection Result:</span>
                            <span>
                                @if($operationDetails->inspection_result)
                                    <span class="badge badge-{{
                                        $operationDetails->inspection_result === 'passed' ? 'success' :
                                        ($operationDetails->inspection_result === 'failed' ? 'danger' : 'warning')
                                    }}">
                                        {{ ucfirst($operationDetails->inspection_result) }}
                                    </span>
                                @else
                                    -
                                @endif
                            </span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between px-0">
                            <span>Approved By:</span>
                            <span>{{ $operationDetails->approved_by }}</span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between px-0">
                            <span>Approval Date:</span>
                            <span>{{ $operationDetails->approved_at ? $operationDetails->approved_at->format('d M, Y H:i') : 'Not approved' }}</span>
                        </div>
                    </div>

                    @if($operationDetails->inspection_notes)
                        <div class="mt-3">
                            <strong>Inspection Notes:</strong>
                            <div class="mt-1 p-2 bg-light rounded">
                                {{ $operationDetails->inspection_notes }}
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="material-icons mr-2">timeline</i>
                        Record Timeline
                    </h6>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        <div class="list-group-item d-flex justify-content-between px-0">
                            <span>Created:</span>
                            <span>{{ $itemDetails->created_at ? $itemDetails->created_at->format('d M, Y H:i') : '-' }}</span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between px-0">
                            <span>Last Updated:</span>
                            <span>{{ $itemDetails->updated_at ? $itemDetails->updated_at->format('d M, Y H:i') : '-' }}</span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between px-0">
                            <span>Operation Created:</span>
                            <span>{{ $operationDetails->created_at ? $operationDetails->created_at->format('d M, Y H:i') : '-' }}</span>
                        </div>
                    </div>

                    <div class="mt-3">
                        <small class="text-muted">
                            <strong>Item Record ID:</strong> {{ $itemDetails->id }}<br>
                            <strong>Operation ID:</strong> {{ $operationDetails->id }}
                        </small>
                    </div>

                    @if($operationDetails->notes)
                        <div class="mt-3">
                            <strong>Operation Notes:</strong>
                            <div class="mt-1 p-2 bg-light rounded">
                                {{ $operationDetails->notes }}
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

@push('styles')
    <style>
        .table-borderless td {
            border: none;
            padding: 0.25rem 0.5rem;
        }

        .badge-outline-primary {
            color: #007bff;
            border: 1px solid #007bff;
            background-color: transparent;
        }

        .badge-outline-info {
            color: #17a2b8;
            border: 1px solid #17a2b8;
            background-color: transparent;
        }

        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            font-size: 12px;
        }

        .table td {
            font-size: 13px;
            vertical-align: middle;
        }

        .list-group-item {
            border-left: none;
            border-right: none;
        }

        code {
            font-size: 12px;
            color: #6c757d;
            background-color: #f8f9fa;
            padding: 2px 6px;
            border-radius: 3px;
        }

        .progress {
            background-color: #e9ecef;
        }

        .progress-bar {
            font-size: 11px;
            line-height: 20px;
        }
    </style>
@endpush

@push('scripts')
    <script>
        function printItemDetails() {
            window.print();
        }
    </script>
@endpush