@extends('layouts.admin-simple')

@section('title', 'Edit Category')
@section('page-title', 'Edit Category')
@section('page-subtitle', 'Update item category information')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('warehouse.item-categories.index') }}">Item Categories</a></li>
    <li class="breadcrumb-item active">Edit</li>
@endsection

@section('content')
<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex justify-content-between align-items-center">
        <h6 class="m-0 font-weight-bold text-primary">Edit Category Information</h6>
        <span class="text-muted">ID: {{ $category->id }}</span>
    </div>

    <div class="card-body">
        <form action="{{ route('warehouse.item-categories.update', $category->id) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="category_name" class="form-label">Category Name <span class="text-danger">*</span></label>
                        <input type="text" name="category_name" id="category_name"
                               class="form-control @error('category_name') is-invalid @enderror"
                               value="{{ old('category_name', $category->category_name) }}" required>
                        @error('category_name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="category_code" class="form-label">Category Code</label>
                        <input type="text" name="category_code" id="category_code"
                               class="form-control @error('category_code') is-invalid @enderror"
                               value="{{ old('category_code', $category->category_code) }}" maxlength="20" placeholder="Enter unique category code">
                        <small class="form-text text-muted">Must be unique across all categories</small>
                        @error('category_code')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label for="type_of_goods" class="form-label">Type of Goods</label>
                        <input type="text" name="type_of_goods" id="type_of_goods"
                               class="form-control @error('type_of_goods') is-invalid @enderror"
                               value="{{ old('type_of_goods', $category->type_of_goods) }}">
                        @error('type_of_goods')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                        <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                            <option value="active" {{ old('status', $category->status) == 'active' ? 'selected' : '' }}>Active</option>
                            <option value="inactive" {{ old('status', $category->status) == 'inactive' ? 'selected' : '' }}>Inactive</option>
                        </select>
                        @error('status')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label for="description" class="form-label">Description</label>
                        <textarea name="description" id="description" rows="3"
                                  class="form-control @error('description') is-invalid @enderror"
                                  placeholder="Optional description for this category">{{ old('description', $category->description) }}</textarea>
                        @error('description')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="d-flex justify-content-between mt-4 pt-3 border-top">
                <a href="{{ route('warehouse.item-categories.index') }}" class="btn btn-secondary">
                    <i class="material-icons mr-1" style="font-size: 16px;">cancel</i>
                    Cancel
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="material-icons mr-1" style="font-size: 16px;">save</i>
                    Update Category
                </button>
            </div>
        </form>
    </div>
</div>
@endsection