<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Material Delivery Note</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            font-size: 12px;
            line-height: 1.4;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .company-name {
            font-weight: bold;
            font-size: 14px;
            margin-bottom: 5px;
        }
        .company-details {
            font-size: 11px;
            margin-bottom: 3px;
        }
        .title {
            font-weight: bold;
            font-size: 16px;
            margin: 30px 0 20px 0;
            text-align: center;
        }
        .info-section {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
        }
        .info-left {
            flex: 1;
        }
        .info-right {
            flex: 1;
            text-align: right;
        }
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 40px;
        }
        .items-table th,
        .items-table td {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
        }
        .items-table th {
            background-color: #f5f5f5;
            font-weight: bold;
        }
        .items-table td {
            height: 30px;
            vertical-align: top;
        }
        .empty-rows {
            height: 200px;
        }
        .signatures {
            display: flex;
            justify-content: space-between;
            margin-top: 50px;
            padding-top: 20px;
        }
        .signature-box {
            text-align: center;
            flex: 1;
            margin: 0 20px;
        }
        .signature-line {
            border-bottom: 1px solid #000;
            height: 40px;
            margin-bottom: 10px;
        }
        @media print {
            body {
                margin: 0;
                padding: 15px;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="company-name">
            ISAM KABBANI & PARTNERS FOR CONSTRUCTION & MAINT. CO. ( L.L.C )
        </div>
        <div class="company-details">
            Dubai: Dubai Investment Park, Jebel Ali Tel# 04 884 1522; Fax# 04 884 1523
        </div>
        <div class="company-details">
            E-mail : dubai@kcgemirates.ae; abudhabi@kcgemirates.ae &nbsp;&nbsp;&nbsp; Website : www.ikkgroup.com
        </div>
    </div>

    <div class="title">
        MATERIAL DELIVERY NOTE
    </div>

    <div class="info-section">
        <div class="info-left">
            <strong>MR#:</strong> {{ $deliveryNote->outgoingTransaction->mr_number ?? '________________' }}<br><br>
            <strong>TO:</strong> {{ $deliveryNote->delivered_to ?? '________________' }}<br><br>
            <strong>Job #</strong> {{ $deliveryNote->project->project_number ?? '________________' }}
        </div>
        <div class="info-right">
            <strong>DATE:</strong> {{ $deliveryNote->generated_date ? $deliveryNote->generated_date->format('d.m.Y') : '________________' }}
        </div>
    </div>

    <table class="items-table">
        <thead>
            <tr>
                <th style="width: 10%;">Sr. No.</th>
                <th style="width: 50%;">Description</th>
                <th style="width: 10%;">Unit</th>
                <th style="width: 10%;">Qty.</th>
                <th style="width: 20%;">Remarks</th>
            </tr>
        </thead>
        <tbody>
            @if(isset($deliveryNote) && $deliveryNote->items && $deliveryNote->items->count() > 0)
                @foreach($deliveryNote->items as $index => $item)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $item->item->item_name ?? '' }}</td>
                    <td>{{ $item->item->unit ?? '' }}</td>
                    <td>{{ $item->quantity_released ?? '' }}</td>
                    <td>{{ $item->remarks ?? '' }}</td>
                </tr>
                @endforeach

                @for($i = $deliveryNote->items->count(); $i < 15; $i++)
                <tr>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                </tr>
                @endfor
            @else
                @for($i = 1; $i <= 15; $i++)
                <tr>
                    <td>{{ $i == 1 ? '1' : '' }}</td>
                    <td>{{ $i == 1 ? 'Masterinject 1315 1Ltr' : '' }}</td>
                    <td>{{ $i == 1 ? 'GAL' : '' }}</td>
                    <td>{{ $i == 1 ? '30' : '' }}</td>
                    <td>&nbsp;</td>
                </tr>
                @endfor
            @endif
        </tbody>
    </table>

    <div class="signatures">
        <div class="signature-box">
            <div class="signature-line"></div>
            <strong>Store Keeper</strong>
        </div>
        <div class="signature-box">
            <div class="signature-line"></div>
            <strong>Site In Charge</strong>
        </div>
        <div class="signature-box">
            <div class="signature-line"></div>
            <strong>Received By (Sign & Date)</strong>
        </div>
    </div>

    <script>
        // Auto-print when page loads
        window.onload = function() {
            // Small delay to ensure page is fully loaded
            setTimeout(function() {
                window.print();
            }, 500);
        };

        // Handle print dialog completion
        window.onafterprint = function() {
            // Optional: Close the window after printing (uncomment if desired)
            // window.close();
        };
    </script>
</body>
</html>