<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Admin Panel') - {{ config('app.name') }}</title>

    <!-- Admin Favicon -->
    <link rel="icon" type="image/png" href="{{ asset($siteSettings['admin_favicon'] ?? $siteSettings['site_favicon'] ?? 'images/favicon.ico') }}">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

    <!-- Temporary fix - removed problematic built assets -->
    <style>
        * { font-family: 'Poppins', sans-serif !important; }
        body { background-color: #f4f6f9 !important; }
    </style>

    <!-- Material Icons -->
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">

    <!-- Admin Assets -->
    <link type="text/css" href="{{ asset('admin-assets/css/app.css') }}" rel="stylesheet">
    
    <!-- Admin Custom Styles -->
    <link type="text/css" href="{{ asset('admin-assets/css/admin-custom.css') }}" rel="stylesheet">

    <!-- Custom Brand Styles -->
    <style>
        @media (max-width: 576px) {
            .navbar-brand-text {
                display: none !important;
            }
        }
        @media (max-width: 768px) {
            .navbar-brand-text {
                font-size: 16px !important;
            }
        }
    </style>

    @stack('styles')
</head>

<body class="layout-default">
    <div class="preloader"></div>

    <!-- Header Layout -->
    <div class="mdk-header-layout js-mdk-header-layout">

        <!-- Header -->
        <div id="header" class="mdk-header js-mdk-header m-0" data-fixed>
            <div class="mdk-header__content">
                <div class="navbar navbar-expand-sm navbar-main navbar-light bg-light pr-0" id="navbar" data-primary>
                    <div class="container-fluid p-0">

                        <!-- Navbar toggler -->
                        <button class="navbar-toggler navbar-toggler-right d-block d-lg-none" type="button" data-toggle="sidebar">
                            <span class="navbar-toggler-icon"></span>
                        </button>

                        <!-- Navbar Brand -->
                        <a href="{{ route('admin.dashboard') }}" class="navbar-brand d-flex align-items-center">
                            <img src="{{ asset($siteSettings['site_logo'] ?? 'assets/images/admin-logo.svg') }}" alt="{{ $siteSettings['site_name'] ?? 'UFG' }} Logo" style="height: 52px;" class="navbar-brand-img mr-2">
                            <span class="navbar-brand-text font-weight-bold" style="font-size: 18px; color: #2c3e50;">{{ $siteSettings['site_name'] ?? 'KCG Inventory' }}</span>
                        </a>

                        <!-- Search Form -->
                        <form class="search-form d-none d-sm-flex flex" action="#">
                            <button class="btn" type="submit"><i class="material-icons">search</i></button>
                            <input type="text" class="form-control" placeholder="Search">
                        </form>

                        <!-- Navbar Menu -->
                        <ul class="nav navbar-nav ml-auto">
                            <!-- Custom Profile Dropdown -->
                            <li class="nav-item">
                                @php
                                    $user = auth()->user();
                                    $userName = $user ? $user->name : 'KCG Administrator';
                                    $userEmail = $user ? $user->email : 'admin@kcg.com';
                                    $userRole = $user && $user->role ? $user->role->display_name : 'Administrator';
                                    $userInitial = strtoupper(substr($userName, 0, 1));
                                @endphp

                                <div class="profile-dropdown">
                                    <button type="button" id="profileDropdown" class="profile-dropdown-toggle">
                                        <div class="d-flex align-items-center">
                                            <div style="width: 35px; height: 35px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; margin-right: 10px;">
                                                {{ $userInitial }}
                                            </div>
                                            <div class="d-none d-sm-block text-left">
                                                <div style="font-size: 14px; font-weight: 500; color: #333;">{{ $userName }}</div>
                                                <div style="font-size: 12px; color: #666;">{{ $userRole }}</div>
                                            </div>
                                        </div>
                                    </button>

                                    <div class="profile-dropdown-menu" id="profileMenu" style="display: none;">
                                        <div class="dropdown-header">
                                            <div class="user-info">
                                                <div class="avatar-large">
                                                    <span class="avatar-text">{{ $userInitial }}</span>
                                                </div>
                                                <div class="user-details">
                                                    <h6>{{ $userName }}</h6>
                                                    <p>{{ $userEmail }}</p>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="dropdown-body">
                                            <a href="{{ route('admin.profile') }}" class="dropdown-link">
                                                <i class="material-icons">person</i>
                                                <span>Profile Settings</span>
                                            </a>
                                            <a href="#" class="dropdown-link" onclick="alert('Help center coming soon!'); return false;">
                                                <i class="material-icons">help</i>
                                                <span>Help Center</span>
                                            </a>
                                        </div>

                                        <div class="dropdown-footer">
                                            <form method="POST" action="{{ route('admin.logout') }}" class="logout-form">
                                                @csrf
                                                <button type="submit" class="logout-btn">
                                                    <i class="material-icons">logout</i>
                                                    <span>Sign Out</span>
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Header Layout Content -->
        <div class="mdk-header-layout__content">
            <div class="mdk-drawer-layout js-mdk-drawer-layout" data-push data-responsive-width="992px">
                <div class="mdk-drawer-layout__content page">

                    <!-- Page Heading -->
                    <div class="container-fluid page__heading-container">
                        <div class="page__heading">
                            <div class="mb-3">
                                <nav aria-label="breadcrumb">
                                    <ol class="breadcrumb mb-0">
                                        @yield('breadcrumb')
                                    </ol>
                                </nav>
                            </div>
                            @if(View::hasSection('page-title'))
                                @yield('page-title')
                            @else
                                <div class="d-flex justify-content-between align-items-center">
                                    @yield('page-actions')
                                </div>
                            @endif
                        </div>
                    </div>

                    <!-- Page Content -->
                    <div class="container-fluid page__container">
                        @if(session('success'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                {{ session('success') }}
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        @endif
                        
                        @if(session('error'))
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                {{ session('error') }}
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        @endif
                        
                        @yield('content')
                    </div>

                </div>

                <!-- Sidebar -->
                <div class="mdk-drawer js-mdk-drawer" id="default-drawer" data-align="start">
                    <div class="mdk-drawer__content">
                        <div class="sidebar sidebar-light sidebar-left sidebar-p-t" data-perfect-scrollbar>
                            <div>
                                <div class="sidebar-heading">Menu</div>
                                
                                <ul class="sidebar-menu">
                                    <!-- Dashboard -->
                                    <li class="sidebar-menu-item {{ request()->is('admin/dashboard') ? 'active' : '' }}">
                                        <a class="sidebar-menu-button" href="{{ route('admin.dashboard') }}">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">dashboard</i>
                                            <span class="sidebar-menu-text">Dashboard</span>
                                        </a>
                                    </li>

                                    <!-- Warehouse Section -->
                                    @can('warehouse.access')
                                    <div class="sidebar-heading mt-3">
                                        <i class="material-icons mr-2" style="font-size: 18px; vertical-align: middle;">inventory_2</i>
                                        Warehouse
                                    </div>
                                    <hr class="sidebar-divider">

                                    <!-- Suppliers -->
                                    @can('warehouse.suppliers.view')
                                    <li class="sidebar-menu-item {{ request()->is('warehouse/suppliers*') ? 'active' : '' }}">
                                        <a class="sidebar-menu-button" href="{{ route('warehouse.suppliers.index') }}">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">business</i>
                                            <span class="sidebar-menu-text">Suppliers</span>
                                        </a>
                                    </li>
                                    @endcan

                                    <!-- Projects -->
                                    @if(auth()->user()->can('warehouse.projects.view') || auth()->user()->can('warehouse.project-divisions.view'))
                                    <li class="sidebar-menu-item {{ request()->is('warehouse/projects*') || request()->is('warehouse/project-divisions*') ? 'active open' : '' }}">
                                        <a class="sidebar-menu-button" data-toggle="collapse" href="#projects_menu">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">work</i>
                                            <span class="sidebar-menu-text">Projects</span>
                                            <span class="ml-auto sidebar-menu-toggle-icon"></span>
                                        </a>
                                        <ul class="sidebar-submenu collapse {{ request()->is('warehouse/projects*') || request()->is('warehouse/project-divisions*') ? 'show' : '' }}" id="projects_menu">
                                            @can('warehouse.projects.view')
                                            <li class="sidebar-menu-item {{ request()->is('warehouse/projects*') && !request()->is('warehouse/project-divisions*') ? 'active' : '' }}">
                                                <a class="sidebar-menu-button" href="{{ route('warehouse.projects.index') }}">
                                                    <span class="sidebar-menu-text ml-3">Projects</span>
                                                </a>
                                            </li>
                                            @endcan
                                            @can('warehouse.project-divisions.view')
                                            <li class="sidebar-menu-item {{ request()->is('warehouse/project-divisions*') ? 'active' : '' }}">
                                                <a class="sidebar-menu-button" href="{{ route('warehouse.project-divisions.index') }}">
                                                    <span class="sidebar-menu-text ml-3">Project Divisions</span>
                                                </a>
                                            </li>
                                            @endcan
                                        </ul>
                                    </li>
                                    @endif

                                    <!-- Items -->
                                    @if(auth()->user()->can('warehouse.items.view') || auth()->user()->can('warehouse.item-categories.view'))
                                    <li class="sidebar-menu-item {{ request()->is('warehouse/items*') || request()->is('warehouse/item-categories*') ? 'active open' : '' }}">
                                        <a class="sidebar-menu-button" data-toggle="collapse" href="#items_menu">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">inventory_2</i>
                                            <span class="sidebar-menu-text">Items</span>
                                            <span class="ml-auto sidebar-menu-toggle-icon"></span>
                                        </a>
                                        <ul class="sidebar-submenu collapse {{ request()->is('warehouse/items*') || request()->is('warehouse/item-categories*') ? 'show' : '' }}" id="items_menu">
                                            @can('warehouse.item-categories.view')
                                            <li class="sidebar-menu-item {{ request()->is('warehouse/item-categories*') ? 'active' : '' }}">
                                                <a class="sidebar-menu-button" href="{{ route('warehouse.item-categories.index') }}">
                                                    <span class="sidebar-menu-text ml-3">Item Categories</span>
                                                </a>
                                            </li>
                                            @endcan
                                            @can('warehouse.items.view')
                                            <li class="sidebar-menu-item {{ request()->is('warehouse/items*') ? 'active' : '' }}">
                                                <a class="sidebar-menu-button" href="{{ route('warehouse.items.index') }}">
                                                    <span class="sidebar-menu-text ml-3">Items</span>
                                                </a>
                                            </li>
                                            @endcan
                                        </ul>
                                    </li>
                                    @endif

                                    <!-- Inventory -->
                                    @if(auth()->user()->can('warehouse.inventory.view') || auth()->user()->can('warehouse.inventory.adjust') || auth()->user()->can('warehouse.inventory.transfer') || auth()->user()->can('warehouse.inventory.count'))
                                    <li class="sidebar-menu-item {{ request()->is('warehouse/inventory*') ? 'active open' : '' }}">
                                        <a class="sidebar-menu-button" data-toggle="collapse" href="#inventory_menu">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">inventory</i>
                                            <span class="sidebar-menu-text">Inventory</span>
                                            <span class="ml-auto sidebar-menu-toggle-icon"></span>
                                        </a>
                                        <ul class="sidebar-submenu collapse {{ request()->is('warehouse/inventory*') ? 'show' : '' }}" id="inventory_menu">
                                            @can('warehouse.inventory.view')
                                            <li class="sidebar-menu-item {{ request()->is('warehouse/inventory') && !request()->is('warehouse/inventory/*') ? 'active' : '' }}">
                                                <a class="sidebar-menu-button" href="{{ route('warehouse.inventory.index') }}">
                                                    <span class="sidebar-menu-text ml-3">Dashboard</span>
                                                </a>
                                            </li>
                                            @endcan
                                            @can('warehouse.inventory.view')
                                            <li class="sidebar-menu-item {{ request()->is('warehouse/inventory/low-stock*') ? 'active' : '' }}">
                                                <a class="sidebar-menu-button" href="{{ route('warehouse.inventory.low-stock') }}">
                                                    <span class="sidebar-menu-text ml-3">Low Stock Alerts</span>
                                                </a>
                                            </li>
                                            @endcan
                                            @can('warehouse.inventory.adjust')
                                            <li class="sidebar-menu-item {{ request()->is('warehouse/inventory/adjustments*') ? 'active' : '' }}">
                                                <a class="sidebar-menu-button" href="{{ route('warehouse.inventory.adjustments') }}">
                                                    <span class="sidebar-menu-text ml-3">Stock Adjustments</span>
                                                </a>
                                            </li>
                                            @endcan
                                            @can('warehouse.inventory.count')
                                            <li class="sidebar-menu-item {{ request()->is('warehouse/inventory/physical-count*') ? 'active' : '' }}">
                                                <a class="sidebar-menu-button" href="{{ route('warehouse.inventory.physical-count') }}">
                                                    <span class="sidebar-menu-text ml-3">Cycle Counting</span>
                                                </a>
                                            </li>
                                            @endcan
                                            @can('warehouse.inventory.view')
                                            <li class="sidebar-menu-item {{ request()->is('warehouse/inventory/valuation*') ? 'active' : '' }}">
                                                <a class="sidebar-menu-button" href="{{ route('warehouse.inventory.valuation') }}">
                                                    <span class="sidebar-menu-text ml-3">Inventory Valuation</span>
                                                </a>
                                            </li>
                                            @endcan
                                            @can('warehouse.inventory.view')
                                            <li class="sidebar-menu-item {{ request()->is('warehouse/inventory/aging-report*') ? 'active' : '' }}">
                                                <a class="sidebar-menu-button" href="{{ route('warehouse.inventory.aging-report') }}">
                                                    <span class="sidebar-menu-text ml-3">Aging Report</span>
                                                </a>
                                            </li>
                                            @endcan
                                        </ul>
                                    </li>
                                    @endif

                                    <!-- Enhanced Incoming Operations -->
                                    @if(auth()->user()->can('warehouse.incoming.view') || auth()->user()->can('warehouse.incoming.create') || auth()->user()->can('warehouse.incoming.edit'))
                                    <li class="sidebar-menu-item {{ request()->is('warehouse/incoming-operations*') || request()->is('warehouse/supplier-delivery*') || request()->is('warehouse/site-return*') ? 'active open' : '' }}">
                                        <a class="sidebar-menu-button" data-toggle="collapse" href="#incoming_operations_menu">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">input</i>
                                            <span class="sidebar-menu-text">Incoming Operations</span>
                                            <span class="ml-auto sidebar-menu-toggle-icon"></span>
                                        </a>
                                        <ul class="sidebar-submenu collapse {{ request()->is('warehouse/incoming-operations*') || request()->is('warehouse/supplier-delivery*') || request()->is('warehouse/site-return*') ? 'show' : '' }}" id="incoming_operations_menu">
                                            @can('warehouse.incoming.view')
                                            <li class="sidebar-menu-item {{ request()->is('warehouse/incoming-operations') && !request()->has('type') && !request()->has('operation_type') ? 'active' : '' }}">
                                                <a class="sidebar-menu-button" href="{{ route('warehouse.incoming-operations.index') }}">
                                                    <span class="sidebar-menu-text ml-3">Dashboard</span>
                                                </a>
                                            </li>
                                            @endcan
                                            @can('warehouse.incoming.view')
                                            <li class="sidebar-menu-item {{ request()->is('warehouse/supplier-delivery*') ? 'active' : '' }}">
                                                <a class="sidebar-menu-button" href="{{ route('warehouse.supplier-delivery.index') }}">
                                                    <span class="sidebar-menu-text ml-3">Supplier Deliveries</span>
                                                </a>
                                            </li>
                                            @endcan
                                            @can('warehouse.incoming.view')
                                            <li class="sidebar-menu-item {{ request()->is('warehouse/site-return*') ? 'active' : '' }}">
                                                <a class="sidebar-menu-button" href="{{ route('warehouse.site-return.index') }}">
                                                    <span class="sidebar-menu-text ml-3">Site Returns</span>
                                                </a>
                                            </li>
                                            @endcan
                                        </ul>
                                    </li>
                                    @endif

                                    <!-- Outgoing Transactions -->
                                    @if(auth()->user()->can('warehouse.outgoing.view') || auth()->user()->can('warehouse.outgoing.create') || auth()->user()->can('warehouse.outgoing.edit'))
                                    <li class="sidebar-menu-item {{ request()->is('warehouse/outgoing*') ? 'active open' : '' }}">
                                        <a class="sidebar-menu-button" data-toggle="collapse" href="#outgoing_transactions_menu">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">output</i>
                                            <span class="sidebar-menu-text">Outgoing Transactions</span>
                                            <span class="ml-auto sidebar-menu-toggle-icon"></span>
                                        </a>
                                        <ul class="sidebar-submenu collapse {{ request()->is('warehouse/outgoing*') ? 'show' : '' }}" id="outgoing_transactions_menu">
                                            @can('warehouse.outgoing.view')
                                            <li class="sidebar-menu-item {{ request()->is('warehouse/outgoing') && !request()->is('warehouse/outgoing/*') ? 'active' : '' }}">
                                                <a class="sidebar-menu-button" href="{{ route('warehouse.outgoing.index') }}">
                                                    <span class="sidebar-menu-text ml-3">Dashboard</span>
                                                </a>
                                            </li>
                                            @endcan
                                            @can('warehouse.outgoing.create')
                                            <li class="sidebar-menu-item {{ request()->is('warehouse/outgoing/create*') ? 'active' : '' }}">
                                                <a class="sidebar-menu-button" href="{{ route('warehouse.outgoing.create') }}">
                                                    <span class="sidebar-menu-text ml-3">Material Request</span>
                                                </a>
                                            </li>
                                            @endcan
                                            @can('warehouse.inventory.view')
                                            <li class="sidebar-menu-item {{ request()->is('warehouse/inventory/material-requests*') ? 'active' : '' }}">
                                                <a class="sidebar-menu-button" href="{{ route('warehouse.inventory.material-requests') }}">
                                                    <span class="sidebar-menu-text ml-3">Material Issued</span>
                                                </a>
                                            </li>
                                            @endcan
                                        </ul>
                                    </li>
                                    @endif


                                    <!-- Reports -->
                                    @can('warehouse.reports.view')
                                    <li class="sidebar-menu-item {{ request()->is('warehouse/reports*') ? 'active' : '' }}">
                                        <a class="sidebar-menu-button" href="{{ route('warehouse.reports.index') }}">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">assessment</i>
                                            <span class="sidebar-menu-text">Reports</span>
                                        </a>
                                    </li>
                                    @endcan

                                    <!-- Analytics -->
                                    @can('warehouse.analytics.view')
                                    <li class="sidebar-menu-item {{ request()->is('warehouse/analytics*') ? 'active' : '' }}">
                                        <a class="sidebar-menu-button" href="{{ route('warehouse.analytics.index') }}">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">analytics</i>
                                            <span class="sidebar-menu-text">Analytics</span>
                                        </a>
                                    </li>
                                    @endcan

                                    <!-- Warehouse Settings -->
                                    @can('warehouse.settings.view')
                                    <li class="sidebar-menu-item {{ request()->is('warehouse/settings*') ? 'active' : '' }}">
                                        <a class="sidebar-menu-button" href="{{ route('warehouse.settings.index') }}">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">tune</i>
                                            <span class="sidebar-menu-text">Warehouse Settings</span>
                                        </a>
                                    </li>
                                    @endcan
                                    @endcan

                                    <!-- Careers Management Removed -->

                                    <!-- Media Management Removed -->

                                    <!-- Product Management Removed -->

                                    <!-- Reports Management Removed -->

                                    <!-- Pages Management Removed -->

                                    <!-- Site Settings -->
                                    @if(auth()->user()->hasPermission('view_settings') || auth()->user()->hasPermission('manage_settings'))
                                    <li class="sidebar-menu-item {{ request()->is('admin/site-settings*') ? 'active' : '' }}">
                                        <a class="sidebar-menu-button" href="{{ route('admin.site-settings.index') }}">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">settings</i>
                                            <span class="sidebar-menu-text">Site Settings</span>
                                        </a>
                                    </li>
                                    @endif

                                    <!-- Investor Inquiries Removed -->

                                    <!-- Team Members Removed -->

                                    <!-- Contact Inquiries Removed -->

                                    <!-- User System -->
                                    @if(auth()->user()->hasPermission('view_users') || auth()->user()->hasPermission('manage_roles') || auth()->user()->hasPermission('manage_departments') || auth()->user()->hasPermission('view_activity_logs'))
                                    <li class="sidebar-menu-item {{ request()->is('admin/users*') || request()->is('admin/roles*') || request()->is('admin/permissions*') || request()->is('admin/departments*') || request()->is('admin/activity-logs*') ? 'active open' : '' }}">
                                        <a class="sidebar-menu-button" data-toggle="collapse" href="#user_system_menu">
                                            <i class="sidebar-menu-icon sidebar-menu-icon--left material-icons">admin_panel_settings</i>
                                            <span class="sidebar-menu-text">User System</span>
                                            <span class="ml-auto sidebar-menu-toggle-icon"></span>
                                        </a>
                                        <ul class="sidebar-submenu collapse {{ request()->is('admin/users*') || request()->is('admin/roles*') || request()->is('admin/permissions*') || request()->is('admin/departments*') || request()->is('admin/activity-logs*') ? 'show' : '' }}" id="user_system_menu">
                                            
                                            @if(auth()->user()->hasPermission('view_users'))
                                            <!-- Users Management Section -->
                                            <li class="sidebar-menu-item">
                                                <a class="sidebar-menu-button disabled">
                                                    <span class="sidebar-menu-text text-muted font-weight-bold">USERS</span>
                                                </a>
                                            </li>
                                            <li class="sidebar-menu-item {{ request()->is('admin/users') && !request()->has('action') ? 'active' : '' }}">
                                                <a class="sidebar-menu-button" href="{{ route('admin.users') }}">
                                                    <span class="sidebar-menu-text ml-3">All Users</span>
                                                </a>
                                            </li>
                                            @if(auth()->user()->hasPermission('create_users'))
                                            <li class="sidebar-menu-item">
                                                <a class="sidebar-menu-button" href="#" data-toggle="modal" data-target="#createUserModal">
                                                    <span class="sidebar-menu-text ml-3">Add User</span>
                                                </a>
                                            </li>
                                            @endif
                                            @endif
                                            
                                            @if(auth()->user()->hasPermission('manage_roles'))
                                            <!-- Roles & Permissions Section -->
                                            <li class="sidebar-menu-item mt-2">
                                                <a class="sidebar-menu-button disabled">
                                                    <span class="sidebar-menu-text text-muted font-weight-bold">ROLES & PERMISSIONS</span>
                                                </a>
                                            </li>
                                            <li class="sidebar-menu-item {{ request()->is('admin/roles') && !request()->is('admin/roles/create') ? 'active' : '' }}">
                                                <a class="sidebar-menu-button" href="{{ route('admin.roles') }}">
                                                    <span class="sidebar-menu-text ml-3">Manage Roles</span>
                                                </a>
                                            </li>
                                            <li class="sidebar-menu-item {{ request()->is('admin/roles/create') ? 'active' : '' }}">
                                                <a class="sidebar-menu-button" href="{{ route('admin.roles.create') }}">
                                                    <span class="sidebar-menu-text ml-3">Create Role</span>
                                                </a>
                                            </li>
                                            <li class="sidebar-menu-item {{ request()->is('admin/permissions') ? 'active' : '' }}">
                                                <a class="sidebar-menu-button" href="{{ route('admin.permissions') }}">
                                                    <span class="sidebar-menu-text ml-3">View Permissions</span>
                                                </a>
                                            </li>
                                            @endif
                                            
                                            @if(auth()->user()->hasPermission('manage_departments'))
                                            <!-- Departments Section -->
                                            <li class="sidebar-menu-item mt-2">
                                                <a class="sidebar-menu-button disabled">
                                                    <span class="sidebar-menu-text text-muted font-weight-bold">ORGANIZATION</span>
                                                </a>
                                            </li>
                                            <li class="sidebar-menu-item {{ request()->is('admin/departments*') ? 'active' : '' }}">
                                                <a class="sidebar-menu-button" href="{{ route('admin.departments') }}">
                                                    <span class="sidebar-menu-text ml-3">Departments</span>
                                                </a>
                                            </li>
                                            @endif
                                            
                                            @if(auth()->user()->hasPermission('view_activity_logs'))
                                            <!-- Activity Logs Section -->
                                            <li class="sidebar-menu-item mt-2">
                                                <a class="sidebar-menu-button disabled">
                                                    <span class="sidebar-menu-text text-muted font-weight-bold">ACTIVITY</span>
                                                </a>
                                            </li>
                                            <li class="sidebar-menu-item {{ request()->is('admin/activity-logs*') ? 'active' : '' }}">
                                                <a class="sidebar-menu-button" href="{{ route('admin.activity-logs') }}">
                                                    <span class="sidebar-menu-text ml-3">Activity Logs</span>
                                                </a>
                                            </li>
                                            @endif
                                        </ul>
                                    </li>
                                    @endif
                                </ul>
                            </div>

                            <!-- FlowDash User Account Component -->
                            <div class="d-flex align-items-center sidebar-p-a border-bottom sidebar-account">
                                <a href="#" class="flex d-flex align-items-center text-underline-0 text-body">
                                    <span class="avatar avatar-sm mr-2">
                                        <span class="avatar-title rounded-circle" style="background-color: #038BB9; color: white;">
                                            {{ substr(auth()->user()->name ?? 'A', 0, 1) }}
                                        </span>
                                    </span>
                                    <span class="flex d-flex flex-column">
                                        <strong>{{ auth()->user()->name ?? 'AUFG Admin' }}</strong>
                                        <small class="text-muted text-uppercase">{{ auth()->user()->role->display_name ?? 'User' }}</small>
                                    </span>
                                </a>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    @yield('modals')

    <!-- Page Loading Overlay -->
    <div class="page-loading-overlay" id="pageLoadingOverlay">
        <div class="loading-spinner"></div>
        <div class="loading-text">Loading...</div>
    </div>

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Bootstrap -->
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.min.js"></script>

    <!-- PerfectScrollbar (load before app.js) -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/perfect-scrollbar/1.5.5/css/perfect-scrollbar.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/perfect-scrollbar/1.5.5/perfect-scrollbar.min.js"></script>

    <!-- Admin Assets (only the ones that exist) -->
    <script src="{{ asset('admin-assets/vendor/dom-factory.js') }}"></script>
    <script src="{{ asset('admin-assets/vendor/material-design-kit.js') }}"></script>
    <script src="{{ asset('admin-assets/js/app.js') }}"></script>
    
    <!-- Admin Custom JavaScript -->
    <script src="{{ asset('admin-assets/js/admin-custom.js') }}"></script>

    @stack('scripts')
</body>
</html>