<!-- Warehouse Page Header Component -->
@props([
    'title' => '',
    'subtitle' => '',
    'breadcrumbs' => [],
    'actions' => []
])

<div class="warehouse-page-header mb-4">
    <!-- Breadcrumbs -->
    @if(!empty($breadcrumbs))
        <x-warehouse.breadcrumb :items="$breadcrumbs" />
    @endif

    <!-- Page Title & Actions -->
    <div class="d-flex justify-content-between align-items-start">
        <div class="warehouse-page-title">
            @if($title)
                <h1 class="h3 mb-0 text-dark font-weight-bold">{{ $title }}</h1>
            @endif
            @if($subtitle)
                <p class="text-muted mb-0 mt-1">{{ $subtitle }}</p>
            @endif
        </div>

        @if(!empty($actions))
            <div class="warehouse-page-actions">
                <div class="btn-toolbar" role="toolbar">
                    @foreach($actions as $action)
                        @if($action['type'] === 'dropdown')
                            <div class="btn-group mr-2" role="group">
                                <button type="button"
                                        class="btn btn-{{ $action['color'] ?? 'primary' }} dropdown-toggle"
                                        data-toggle="dropdown">
                                    @if(isset($action['icon']))
                                        <i class="material-icons mr-1" style="font-size: 16px;">{{ $action['icon'] }}</i>
                                    @endif
                                    {{ $action['label'] }}
                                </button>
                                <div class="dropdown-menu">
                                    @foreach($action['items'] ?? [] as $item)
                                        <a class="dropdown-item" href="{{ $item['url'] ?? '#' }}">
                                            @if(isset($item['icon']))
                                                <i class="material-icons mr-2" style="font-size: 16px;">{{ $item['icon'] }}</i>
                                            @endif
                                            {{ $item['label'] }}
                                        </a>
                                    @endforeach
                                </div>
                            </div>
                        @else
                            <div class="btn-group mr-2" role="group">
                                <a href="{{ $action['url'] ?? '#' }}"
                                   class="btn btn-{{ $action['color'] ?? 'primary' }}"
                                   @if(isset($action['onclick'])) onclick="{{ $action['onclick'] }}" @endif
                                   @if(isset($action['target'])) target="{{ $action['target'] }}" @endif>
                                    @if(isset($action['icon']))
                                        <i class="material-icons mr-1" style="font-size: 16px;">{{ $action['icon'] }}</i>
                                    @endif
                                    {{ $action['label'] }}
                                </a>
                            </div>
                        @endif
                    @endforeach
                </div>
            </div>
        @endif
    </div>

    <!-- Additional Content Slot -->
    @if($slot->isNotEmpty())
        <div class="warehouse-page-header-content mt-3">
            {{ $slot }}
        </div>
    @endif
</div>

<style>
.warehouse-page-header {
    background: transparent;
    padding: 0;
}

.warehouse-page-title h1 {
    color: #2c3e50;
    font-size: 1.75rem;
    line-height: 1.3;
}

.warehouse-page-title p {
    font-size: 0.95rem;
    line-height: 1.4;
}

.warehouse-page-actions .btn {
    border-radius: 4px;
    font-weight: 500;
    padding: 0.5rem 1rem;
    transition: all 0.2s ease;
}

.warehouse-page-actions .btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.warehouse-page-actions .btn .material-icons {
    vertical-align: middle;
}

.warehouse-page-actions .dropdown-menu {
    border-radius: 4px;
    border: none;
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}

.warehouse-page-actions .dropdown-item {
    padding: 0.5rem 1rem;
    transition: background-color 0.2s ease;
}

.warehouse-page-actions .dropdown-item:hover {
    background-color: #f8f9fa;
}

.warehouse-page-actions .dropdown-item .material-icons {
    vertical-align: middle;
}

@media (max-width: 768px) {
    .warehouse-page-header .d-flex {
        flex-direction: column;
        align-items: flex-start !important;
    }

    .warehouse-page-actions {
        margin-top: 1rem;
        width: 100%;
    }

    .warehouse-page-actions .btn-toolbar {
        flex-direction: column;
    }

    .warehouse-page-actions .btn-group {
        width: 100%;
        margin-right: 0 !important;
        margin-bottom: 0.5rem;
    }

    .warehouse-page-actions .btn {
        width: 100%;
    }

    .warehouse-page-title h1 {
        font-size: 1.5rem;
    }
}

@media (max-width: 576px) {
    .warehouse-page-title h1 {
        font-size: 1.3rem;
    }
}
</style>