<!-- Warehouse Dashboard Stats Component -->
@props(['loading' => false])

<div class="row warehouse-dashboard-stats">
    <!-- Total Items -->
    <div class="col-lg-3 col-md-6 mb-4">
        <x-warehouse.stats-card
            title="Total Items"
            :value="$loading ? 0 : \App\Models\Warehouse\Item::count()"
            icon="inventory_2"
            color="primary"
            :url="route('warehouse.items.index')"
            subtitle="Active catalog items"
            :loading="$loading"
        />
    </div>

    <!-- Current Stock Value -->
    <div class="col-lg-3 col-md-6 mb-4">
        <x-warehouse.stats-card
            title="Stock Value"
            :value="$loading ? 0 : \App\Models\Warehouse\Inventory::sum('total_value')"
            icon="account_balance_wallet"
            color="success"
            :url="route('warehouse.inventory.index')"
            subtitle="Total inventory value"
            :loading="$loading"
            :currency="true"
        />
    </div>

    <!-- Low Stock Items -->
    <div class="col-lg-3 col-md-6 mb-4">
        @php
            // Calculate low stock by checking inventory quantities against item reorder points
            $lowStockCount = $loading ? 0 : \App\Models\Warehouse\Item::whereHas('inventories', function($query) {
                $query->whereColumn('quantity_available', '<=', 'items.reorder_point');
            })->count();
        @endphp
        <x-warehouse.stats-card
            title="Low Stock"
            :value="$lowStockCount"
            icon="warning"
            :color="$lowStockCount > 0 ? 'warning' : 'success'"
            :url="route('warehouse.reports.low-stock')"
            subtitle="Items below reorder point"
            :loading="$loading"
        />
    </div>

    <!-- Pending Operations -->
    <div class="col-lg-3 col-md-6 mb-4">
        @php
            $pendingCount = $loading ? 0 : \App\Models\Warehouse\IncomingOperation::where('status', 'pending_inspection')->count();
        @endphp
        <x-warehouse.stats-card
            title="Pending"
            :value="$pendingCount"
            icon="pending"
            :color="$pendingCount > 0 ? 'info' : 'secondary'"
            :url="route('warehouse.incoming-operations.index', ['status' => 'pending_inspection'])"
            subtitle="Pending inspections"
            :loading="$loading"
        />
    </div>
</div>

<!-- Additional Stats Row -->
<div class="row warehouse-additional-stats">
    <!-- Today's Incoming -->
    <div class="col-lg-4 col-md-6 mb-4">
        @php
            $todayIncoming = $loading ? 0 : \App\Models\Warehouse\IncomingOperation::whereDate('created_at', today())->count();
        @endphp
        <x-warehouse.stats-card
            title="Today's Incoming"
            :value="$todayIncoming"
            icon="input"
            color="info"
            :url="route('warehouse.incoming-operations.index', ['date_from' => today()->format('Y-m-d')])"
            subtitle="Operations created today"
            :loading="$loading"
        />
    </div>

    <!-- Today's Outgoing -->
    <div class="col-lg-4 col-md-6 mb-4">
        @php
            $todayOutgoing = $loading ? 0 : \App\Models\Warehouse\OutgoingTransaction::whereDate('created_at', today())->count();
        @endphp
        <x-warehouse.stats-card
            title="Today's Outgoing"
            :value="$todayOutgoing"
            icon="output"
            color="secondary"
            :url="route('warehouse.outgoing.index', ['date' => today()->format('Y-m-d')])"
            subtitle="Goods dispatched today"
            :loading="$loading"
        />
    </div>

    <!-- Active Suppliers -->
    <div class="col-lg-4 col-md-6 mb-4">
        @php
            $activeSuppliers = $loading ? 0 : \App\Models\Warehouse\Supplier::where('status', 'active')->count();
        @endphp
        <x-warehouse.stats-card
            title="Active Suppliers"
            :value="$activeSuppliers"
            icon="business"
            color="primary"
            :url="route('warehouse.suppliers.index')"
            subtitle="Registered suppliers"
            :loading="$loading"
        />
    </div>
</div>