<!-- Edit User Modal -->
<div class="modal fade" id="editUserModal{{ $user->id }}" tabindex="-1" role="dialog" aria-labelledby="editUserModalLabel{{ $user->id }}" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editUserModalLabel{{ $user->id }}">Edit User: {{ $user->full_name }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="editUserForm{{ $user->id }}" data-user-id="{{ $user->id }}">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_first_name{{ $user->id }}">First Name *</label>
                                <input type="text" class="form-control" id="edit_first_name{{ $user->id }}" name="first_name" value="{{ $user->first_name }}" required>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_last_name{{ $user->id }}">Last Name *</label>
                                <input type="text" class="form-control" id="edit_last_name{{ $user->id }}" name="last_name" value="{{ $user->last_name }}" required>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_email{{ $user->id }}">Email Address *</label>
                                <input type="email" class="form-control" id="edit_email{{ $user->id }}" name="email" value="{{ $user->email }}" required>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_phone{{ $user->id }}">Phone Number</label>
                                <input type="text" class="form-control" id="edit_phone{{ $user->id }}" name="phone" value="{{ $user->phone }}">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_employee_id{{ $user->id }}">Employee ID</label>
                                <input type="text" class="form-control" id="edit_employee_id{{ $user->id }}" name="employee_id" value="{{ $user->employee_id }}">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_role_id{{ $user->id }}">Role *</label>
                                <select class="form-control" id="edit_role_id{{ $user->id }}" name="role_id" required>
                                    <option value="">Select Role</option>
                                    @foreach($roles as $role)
                                        <option value="{{ $role->id }}" {{ $user->role_id == $role->id ? 'selected' : '' }}>
                                            {{ $role->display_name }}
                                        </option>
                                    @endforeach
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="edit_status{{ $user->id }}">Status *</label>
                                <select class="form-control" id="edit_status{{ $user->id }}" name="status" required>
                                    <option value="active" {{ $user->status == 'active' ? 'selected' : '' }}>Active</option>
                                    <option value="inactive" {{ $user->status == 'inactive' ? 'selected' : '' }}>Inactive</option>
                                    <option value="suspended" {{ $user->status == 'suspended' ? 'selected' : '' }}>Suspended</option>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                    </div>
                    
                    @if($user->first_login)
                    <div class="alert alert-info">
                        <i class="material-icons mr-2">info</i>
                        This user has not completed their first login yet.
                    </div>
                    @endif
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="material-icons mr-2">save</i>
                        Update User
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.getElementById('editUserForm{{ $user->id }}').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const form = this;
    const userId = form.dataset.userId;
    const submitBtn = form.querySelector('button[type="submit"]');
    const originalText = submitBtn.innerHTML;
    
    // Clear previous errors
    form.querySelectorAll('.is-invalid').forEach(el => el.classList.remove('is-invalid'));
    form.querySelectorAll('.invalid-feedback').forEach(el => el.textContent = '');
    
    // Show loading state
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<i class="material-icons mr-2">hourglass_empty</i> Updating...';
    
    // Submit form
    fetch(`/admin/users/${userId}`, {
        method: 'PUT',
        body: new FormData(form),
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToastMessage(data.message, 'success');
            
            // Close modal and reload page
            $('#editUserModal{{ $user->id }}').modal('hide');
            setTimeout(() => location.reload(), 1000);
        } else {
            // Handle validation errors
            if (data.errors) {
                Object.keys(data.errors).forEach(field => {
                    const input = form.querySelector(`[name="${field}"]`);
                    if (input) {
                        input.classList.add('is-invalid');
                        const feedback = input.nextElementSibling;
                        if (feedback && feedback.classList.contains('invalid-feedback')) {
                            feedback.textContent = data.errors[field][0];
                        }
                    }
                });
            } else {
                showToastMessage(data.message || 'An error occurred', 'error');
            }
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToastMessage('An error occurred while updating the user', 'error');
    })
    .finally(() => {
        submitBtn.disabled = false;
        submitBtn.innerHTML = originalText;
    });
});
</script>