<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class UnitsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $units = [
            // Count/Quantity
            ['unit_code' => 'PCS', 'unit_name' => 'Pieces', 'unit_symbol' => 'pcs', 'unit_type' => 'count', 'description' => 'Individual pieces or items'],
            ['unit_code' => 'SET', 'unit_name' => 'Set', 'unit_symbol' => 'set', 'unit_type' => 'count', 'description' => 'Complete set of items'],
            ['unit_code' => 'PAIR', 'unit_name' => 'Pair', 'unit_symbol' => 'pair', 'unit_type' => 'count', 'description' => 'Two matching items'],
            ['unit_code' => 'DOZEN', 'unit_name' => 'Dozen', 'unit_symbol' => 'doz', 'unit_type' => 'count', 'description' => 'Twelve pieces'],
            ['unit_code' => 'BOX', 'unit_name' => 'Box', 'unit_symbol' => 'box', 'unit_type' => 'count', 'description' => 'Boxed items'],

            // Weight
            ['unit_code' => 'KG', 'unit_name' => 'Kilogram', 'unit_symbol' => 'kg', 'unit_type' => 'weight', 'description' => 'Metric unit of mass'],
            ['unit_code' => 'G', 'unit_name' => 'Gram', 'unit_symbol' => 'g', 'unit_type' => 'weight', 'description' => 'Metric unit of mass'],
            ['unit_code' => 'LB', 'unit_name' => 'Pound', 'unit_symbol' => 'lb', 'unit_type' => 'weight', 'description' => 'Imperial unit of weight'],
            ['unit_code' => 'OZ', 'unit_name' => 'Ounce', 'unit_symbol' => 'oz', 'unit_type' => 'weight', 'description' => 'Imperial unit of weight'],
            ['unit_code' => 'TON', 'unit_name' => 'Ton', 'unit_symbol' => 'ton', 'unit_type' => 'weight', 'description' => 'Metric ton (1000kg)'],

            // Length
            ['unit_code' => 'M', 'unit_name' => 'Meter', 'unit_symbol' => 'm', 'unit_type' => 'length', 'description' => 'Metric unit of length'],
            ['unit_code' => 'CM', 'unit_name' => 'Centimeter', 'unit_symbol' => 'cm', 'unit_type' => 'length', 'description' => 'Metric unit of length'],
            ['unit_code' => 'MM', 'unit_name' => 'Millimeter', 'unit_symbol' => 'mm', 'unit_type' => 'length', 'description' => 'Metric unit of length'],
            ['unit_code' => 'FT', 'unit_name' => 'Foot', 'unit_symbol' => 'ft', 'unit_type' => 'length', 'description' => 'Imperial unit of length'],
            ['unit_code' => 'IN', 'unit_name' => 'Inch', 'unit_symbol' => 'in', 'unit_type' => 'length', 'description' => 'Imperial unit of length'],

            // Volume
            ['unit_code' => 'L', 'unit_name' => 'Liter', 'unit_symbol' => 'L', 'unit_type' => 'volume', 'description' => 'Metric unit of volume'],
            ['unit_code' => 'ML', 'unit_name' => 'Milliliter', 'unit_symbol' => 'ml', 'unit_type' => 'volume', 'description' => 'Metric unit of volume'],
            ['unit_code' => 'GAL', 'unit_name' => 'Gallon', 'unit_symbol' => 'gal', 'unit_type' => 'volume', 'description' => 'Imperial unit of volume'],
            ['unit_code' => 'QT', 'unit_name' => 'Quart', 'unit_symbol' => 'qt', 'unit_type' => 'volume', 'description' => 'Imperial unit of volume'],

            // Area
            ['unit_code' => 'SQM', 'unit_name' => 'Square Meter', 'unit_symbol' => 'm²', 'unit_type' => 'area', 'description' => 'Metric unit of area'],
            ['unit_code' => 'SQFT', 'unit_name' => 'Square Foot', 'unit_symbol' => 'ft²', 'unit_type' => 'area', 'description' => 'Imperial unit of area'],

            // Time
            ['unit_code' => 'HR', 'unit_name' => 'Hour', 'unit_symbol' => 'hr', 'unit_type' => 'time', 'description' => 'Unit of time'],
            ['unit_code' => 'DAY', 'unit_name' => 'Day', 'unit_symbol' => 'day', 'unit_type' => 'time', 'description' => 'Unit of time'],

            // Special
            ['unit_code' => 'PKG', 'unit_name' => 'Package', 'unit_symbol' => 'pkg', 'unit_type' => 'count', 'description' => 'Packaged items'],
            ['unit_code' => 'ROLL', 'unit_name' => 'Roll', 'unit_symbol' => 'roll', 'unit_type' => 'count', 'description' => 'Rolled materials'],
            ['unit_code' => 'SHEET', 'unit_name' => 'Sheet', 'unit_symbol' => 'sheet', 'unit_type' => 'count', 'description' => 'Sheet materials'],
        ];

        foreach ($units as $unit) {
            DB::table('units')->insert([
                'unit_code' => $unit['unit_code'],
                'unit_name' => $unit['unit_name'],
                'unit_symbol' => $unit['unit_symbol'],
                'unit_type' => $unit['unit_type'],
                'description' => $unit['description'],
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}