<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\Role;
use Illuminate\Database\Seeder;

class LegacyPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create legacy permissions that existing controllers expect
        $legacyPermissions = [
            [
                'name' => 'access_admin_dashboard',
                'display_name' => 'Access Admin Dashboard',
                'description' => 'Legacy permission for admin dashboard access',
                'group' => 'legacy_admin'
            ],
            [
                'name' => 'view_users',
                'display_name' => 'View Users (Legacy)',
                'description' => 'Legacy permission to view users',
                'group' => 'legacy_user_management'
            ],
            [
                'name' => 'create_users',
                'display_name' => 'Create Users (Legacy)',
                'description' => 'Legacy permission to create users',
                'group' => 'legacy_user_management'
            ],
            [
                'name' => 'edit_users',
                'display_name' => 'Edit Users (Legacy)',
                'description' => 'Legacy permission to edit users',
                'group' => 'legacy_user_management'
            ],
            [
                'name' => 'delete_users',
                'display_name' => 'Delete Users (Legacy)',
                'description' => 'Legacy permission to delete users',
                'group' => 'legacy_user_management'
            ],
            [
                'name' => 'manage_roles',
                'display_name' => 'Manage Roles (Legacy)',
                'description' => 'Legacy permission to manage roles',
                'group' => 'legacy_role_management'
            ],
            [
                'name' => 'manage_permissions',
                'display_name' => 'Manage Permissions (Legacy)',
                'description' => 'Legacy permission to manage permissions',
                'group' => 'legacy_role_management'
            ],
            [
                'name' => 'manage_departments',
                'display_name' => 'Manage Departments (Legacy)',
                'description' => 'Legacy permission to manage departments',
                'group' => 'legacy_department_management'
            ],
            [
                'name' => 'view_activity_logs',
                'display_name' => 'View Activity Logs (Legacy)',
                'description' => 'Legacy permission to view activity logs',
                'group' => 'legacy_system_monitoring'
            ],
            [
                'name' => 'manage_site_settings',
                'display_name' => 'Manage Site Settings (Legacy)',
                'description' => 'Legacy permission to manage site settings',
                'group' => 'legacy_site_management'
            ],
            [
                'name' => 'view_settings',
                'display_name' => 'View Settings (Legacy)',
                'description' => 'Legacy permission to view settings',
                'group' => 'legacy_site_management'
            ],
            [
                'name' => 'manage_settings',
                'display_name' => 'Manage Settings (Legacy)',
                'description' => 'Legacy permission to manage settings',
                'group' => 'legacy_site_management'
            ],
        ];

        // Create the legacy permissions
        foreach ($legacyPermissions as $permission) {
            Permission::firstOrCreate(
                ['name' => $permission['name']],
                $permission
            );
        }

        // Add legacy permissions to super admin and admin roles
        $superAdminRole = Role::where('name', 'super_admin')->first();
        $adminRole = Role::where('name', 'admin')->first();

        if ($superAdminRole) {
            $legacyPermissionIds = Permission::whereIn('name', array_column($legacyPermissions, 'name'))->pluck('id')->toArray();

            // Get current permissions and add legacy ones
            $currentPermissions = $superAdminRole->permissions()->pluck('permissions.id')->toArray();
            $allPermissions = array_unique(array_merge($currentPermissions, $legacyPermissionIds));

            $superAdminRole->permissions()->sync($allPermissions);
            $this->command->info('Legacy permissions added to Super Admin role!');
        }

        if ($adminRole) {
            $legacyPermissionIds = Permission::whereIn('name', array_column($legacyPermissions, 'name'))->pluck('id')->toArray();

            // Get current permissions and add legacy ones (except delete permissions)
            $currentPermissions = $adminRole->permissions()->pluck('permissions.id')->toArray();
            $adminLegacyPermissions = Permission::whereIn('name', array_column($legacyPermissions, 'name'))
                ->whereNotIn('name', ['delete_users'])
                ->pluck('id')->toArray();

            $allPermissions = array_unique(array_merge($currentPermissions, $adminLegacyPermissions));

            $adminRole->permissions()->sync($allPermissions);
            $this->command->info('Legacy permissions added to Admin role!');
        }

        $this->command->info('Legacy permissions created and assigned successfully!');
        $this->command->info('Your admin user should now have access to:');
        $this->command->info('- User Management (/admin/users)');
        $this->command->info('- Role Management (/admin/roles)');
        $this->command->info('- Department Management (/admin/departments)');
        $this->command->info('- Activity Logs (/admin/activity-logs)');
        $this->command->info('- Site Settings (/admin/site-settings)');
    }
}