<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ItemSeeder extends Seeder
{
    public function run(): void
    {
        $items = [
            // Construction Materials
            [
                'item_code' => 'CM-001',
                'item_description' => 'Portland Cement 50kg bag',
                'category_id' => 1,
                'unit_of_measure' => 'bags',
                'min_stock_level' => 100,
                'max_stock_level' => 500,
                'reorder_point' => 150,
                'status' => 'active',
                'notes' => 'Standard Portland cement for general construction',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'item_code' => 'CM-002',
                'item_description' => 'Rebar 12mm x 6m',
                'category_id' => 1,
                'unit_of_measure' => 'pieces',
                'min_stock_level' => 50,
                'max_stock_level' => 200,
                'reorder_point' => 75,
                'status' => 'active',
                'notes' => 'Reinforcing steel bars for concrete structures',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'item_code' => 'CM-003',
                'item_description' => 'Concrete Blocks 200x200x400mm',
                'category_id' => 1,
                'unit_of_measure' => 'pieces',
                'min_stock_level' => 200,
                'max_stock_level' => 1000,
                'reorder_point' => 300,
                'status' => 'active',
                'notes' => 'Hollow concrete masonry blocks',
                'created_at' => now(),
                'updated_at' => now(),
            ],

            // Electrical Equipment
            [
                'item_code' => 'EE-001',
                'item_description' => 'Electrical Wire 2.5mm² 100m roll',
                'category_id' => 2,
                'unit_of_measure' => 'rolls',
                'min_stock_level' => 20,
                'max_stock_level' => 100,
                'reorder_point' => 30,
                'status' => 'active',
                'notes' => 'Single core electrical wire for residential use',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'item_code' => 'EE-002',
                'item_description' => 'Circuit Breaker 20A Single Pole',
                'category_id' => 2,
                'unit_of_measure' => 'pieces',
                'min_stock_level' => 25,
                'max_stock_level' => 100,
                'reorder_point' => 40,
                'status' => 'active',
                'notes' => 'Single pole circuit breaker for electrical panels',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'item_code' => 'EE-003',
                'item_description' => 'LED Light Fixture 24W',
                'category_id' => 2,
                'unit_of_measure' => 'pieces',
                'min_stock_level' => 15,
                'max_stock_level' => 75,
                'reorder_point' => 25,
                'status' => 'active',
                'notes' => 'Energy efficient LED ceiling fixture',
                'created_at' => now(),
                'updated_at' => now(),
            ],

            // Plumbing Supplies
            [
                'item_code' => 'PS-001',
                'item_description' => 'PVC Pipe 4" x 10ft',
                'category_id' => 3,
                'unit_of_measure' => 'pieces',
                'min_stock_level' => 30,
                'max_stock_level' => 150,
                'reorder_point' => 50,
                'status' => 'active',
                'notes' => 'Schedule 40 PVC pipe for drainage',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'item_code' => 'PS-002',
                'item_description' => 'Copper Pipe 1/2" x 10ft',
                'category_id' => 3,
                'unit_of_measure' => 'pieces',
                'min_stock_level' => 20,
                'max_stock_level' => 100,
                'reorder_point' => 35,
                'status' => 'active',
                'notes' => 'Type L copper pipe for water supply',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'item_code' => 'PS-003',
                'item_description' => 'Ball Valve 1/2" Brass',
                'category_id' => 3,
                'unit_of_measure' => 'pieces',
                'min_stock_level' => 10,
                'max_stock_level' => 50,
                'reorder_point' => 20,
                'status' => 'active',
                'notes' => 'Full port brass ball valve',
                'created_at' => now(),
                'updated_at' => now(),
            ],

            // Safety Equipment
            [
                'item_code' => 'SE-001',
                'item_description' => 'Hard Hat White ANSI Approved',
                'category_id' => 4,
                'unit_of_measure' => 'pieces',
                'min_stock_level' => 50,
                'max_stock_level' => 200,
                'reorder_point' => 75,
                'status' => 'active',
                'notes' => 'OSHA compliant safety helmet',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'item_code' => 'SE-002',
                'item_description' => 'Safety Vest Hi-Vis Orange',
                'category_id' => 4,
                'unit_of_measure' => 'pieces',
                'min_stock_level' => 30,
                'max_stock_level' => 150,
                'reorder_point' => 50,
                'status' => 'active',
                'notes' => 'High visibility safety vest Class 2',
                'created_at' => now(),
                'updated_at' => now(),
            ],

            // Tools & Hardware
            [
                'item_code' => 'TH-001',
                'item_description' => 'Hammer 16oz Claw',
                'category_id' => 5,
                'unit_of_measure' => 'pieces',
                'min_stock_level' => 10,
                'max_stock_level' => 50,
                'reorder_point' => 20,
                'status' => 'active',
                'notes' => 'Steel claw hammer with fiberglass handle',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'item_code' => 'TH-002',
                'item_description' => 'Drill Bit Set HSS 1/16"-1/2"',
                'category_id' => 5,
                'unit_of_measure' => 'sets',
                'min_stock_level' => 5,
                'max_stock_level' => 25,
                'reorder_point' => 10,
                'status' => 'active',
                'notes' => '29-piece high speed steel drill bit set',
                'created_at' => now(),
                'updated_at' => now(),
            ],

            // Fasteners
            [
                'item_code' => 'FS-001',
                'item_description' => 'Wood Screws #8 x 2" Phillips',
                'category_id' => 6,
                'unit_of_measure' => 'boxes',
                'min_stock_level' => 20,
                'max_stock_level' => 100,
                'reorder_point' => 35,
                'status' => 'active',
                'notes' => 'Zinc plated wood screws 100/box',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'item_code' => 'FS-002',
                'item_description' => 'Hex Bolts 1/2" x 3" Grade 8',
                'category_id' => 6,
                'unit_of_measure' => 'pieces',
                'min_stock_level' => 25,
                'max_stock_level' => 100,
                'reorder_point' => 40,
                'status' => 'active',
                'notes' => 'High strength hex head cap screws',
                'created_at' => now(),
                'updated_at' => now(),
            ],

            // Paints & Coatings
            [
                'item_code' => 'PC-001',
                'item_description' => 'Exterior Paint White 1 Gallon',
                'category_id' => 7,
                'unit_of_measure' => 'gallons',
                'min_stock_level' => 15,
                'max_stock_level' => 75,
                'reorder_point' => 25,
                'status' => 'active',
                'notes' => 'Acrylic latex exterior house paint',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'item_code' => 'PC-002',
                'item_description' => 'Primer Sealer 1 Quart',
                'category_id' => 7,
                'unit_of_measure' => 'quarts',
                'min_stock_level' => 20,
                'max_stock_level' => 80,
                'reorder_point' => 30,
                'status' => 'active',
                'notes' => 'Multi-surface primer and sealer',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        DB::table('items')->insert($items);
    }
}