<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sync_history', function (Blueprint $table) {
            $table->integer('updated')->default(0)->after('imported');
            $table->json('division_sync')->nullable()->after('validation_details');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sync_history', function (Blueprint $table) {
            $table->dropColumn('updated');
            $table->dropColumn('division_sync');
        });
    }
};
