<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('incoming_operation_items', function (Blueprint $table) {
            $table->unsignedBigInteger('supplier_delivery_item_id')->nullable()->after('material_transfer_item_id');
            $table->foreign('supplier_delivery_item_id')->references('id')->on('incoming_operation_items')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('incoming_operation_items', function (Blueprint $table) {
            $table->dropForeign(['supplier_delivery_item_id']);
            $table->dropColumn('supplier_delivery_item_id');
        });
    }
};
