<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('incoming_operations', function (Blueprint $table) {
            $table->unsignedBigInteger('supplier_delivery_id')->nullable()->after('material_transfer_id');
            $table->foreign('supplier_delivery_id')->references('id')->on('incoming_operations')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('incoming_operations', function (Blueprint $table) {
            $table->dropForeign(['supplier_delivery_id']);
            $table->dropColumn('supplier_delivery_id');
        });
    }
};
