<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::statement("ALTER TABLE material_transfer_requests MODIFY COLUMN status ENUM('draft', 'pending_transferrer_approval', 'pending_receiver_approval', 'approved', 'partially_approved', 'rejected', 'cancelled') DEFAULT 'draft'");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // First update any 'partially_approved' values to 'approved' before changing the enum
        DB::statement("UPDATE material_transfer_requests SET status = 'approved' WHERE status = 'partially_approved'");

        DB::statement("ALTER TABLE material_transfer_requests MODIFY COLUMN status ENUM('draft', 'pending_transferrer_approval', 'pending_receiver_approval', 'approved', 'rejected', 'cancelled') DEFAULT 'draft'");
    }
};