<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('direct_deliveries', function (Blueprint $table) {
            $table->boolean('project_inventory_updated')->default(false)->after('can_be_returned');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('direct_deliveries', function (Blueprint $table) {
            $table->dropColumn('project_inventory_updated');
        });
    }
};
