<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('incoming_operations', function (Blueprint $table) {
            $table->unsignedBigInteger('direct_delivery_id')->nullable()->after('material_request_id');
            $table->foreign('direct_delivery_id')->references('id')->on('direct_deliveries')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('incoming_operations', function (Blueprint $table) {
            $table->dropForeign(['direct_delivery_id']);
            $table->dropColumn('direct_delivery_id');
        });
    }
};
