<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('material_transfer_requests', function (Blueprint $table) {
            // Add delivery type field to determine if it's inventory or supplier delivery
            $table->enum('delivery_type', ['inventory_delivery', 'supplier_delivery'])
                ->default('inventory_delivery')
                ->after('transfer_request_number');

            // Add reference to direct delivery if supplier delivery is selected
            $table->foreignId('direct_delivery_id')
                ->nullable()
                ->after('delivery_type')
                ->constrained('direct_deliveries')
                ->onDelete('set null');

            // Add index for better query performance
            $table->index(['delivery_type']);
            $table->index(['direct_delivery_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('material_transfer_requests', function (Blueprint $table) {
            $table->dropForeign(['direct_delivery_id']);
            $table->dropIndex(['delivery_type']);
            $table->dropIndex(['direct_delivery_id']);
            $table->dropColumn(['delivery_type', 'direct_delivery_id']);
        });
    }
};