<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->unsignedBigInteger('external_project_id')->nullable()->after('id');
            $table->timestamp('last_synced_at')->nullable()->after('updated_at');

            // Add unique index for external project ID to prevent duplicates
            $table->unique('external_project_id');
            $table->index(['external_project_id', 'last_synced_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->dropUnique(['external_project_id']);
            $table->dropIndex(['external_project_id', 'last_synced_at']);
            $table->dropColumn(['external_project_id', 'last_synced_at']);
        });
    }
};
