<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('supplier_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('supplier_id')->constrained('suppliers')->onDelete('cascade');
            $table->foreignId('item_id')->constrained('items')->onDelete('cascade');
            $table->string('supplier_item_code')->nullable();
            $table->decimal('unit_cost', 10, 2)->nullable();
            $table->integer('lead_time_days')->nullable();
            $table->integer('minimum_order_quantity')->default(1);
            $table->timestamps();

            $table->unique(['supplier_id', 'item_id']);
            $table->index('supplier_item_code');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('supplier_items');
    }
};
