<?php

namespace App\Models\Warehouse;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class MaterialSiteTransferItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'site_transfer_id',
        'item_id',
        'project_inventory_id',
        'quantity_transferred',
        'unit_price',
        'total_value'
    ];

    protected $casts = [
        'quantity_transferred' => 'decimal:3',
        'unit_price' => 'decimal:2',
        'total_value' => 'decimal:2'
    ];

    /**
     * Get the site transfer this item belongs to.
     */
    public function siteTransfer(): BelongsTo
    {
        return $this->belongsTo(MaterialSiteTransfer::class, 'site_transfer_id');
    }

    /**
     * Get the item.
     */
    public function item(): BelongsTo
    {
        return $this->belongsTo(Item::class);
    }

    /**
     * Get the project inventory.
     */
    public function projectInventory(): BelongsTo
    {
        return $this->belongsTo(ProjectInventory::class);
    }
}